<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Administrator\Model;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\MVC\Model\AdminModel;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Registry\Registry;
use Joomla\Utilities\ArrayHelper;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\OrderFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Order;

defined('_JEXEC') or die();



class OrderModel extends AdminModel
{
    protected $text_prefix = 'COM_EVENTGALLERY';



    /**
     * Method to get the record form.
     *
     * @param array $data An optional array of data for the form to interogate.
     * @param boolean $loadData True if the form is to load its own data (default case), false if not.
     * @return Form A JForm object on success, false on failure
     */
    public function getForm($data = array(), $loadData = true)
    {

        // Get the form.
        $form = $this->loadForm('com_eventgallery.order', 'order', array('control' => 'jform', 'load_data' => $loadData));
        if (empty($form)) {
            return false;
        }

        return $form;
    }

    /**
     * Method to get the data that should be injected in the form.
     *
     * @return mixed The data for the form.
     */
    protected function loadFormData()
    {   // Check the session for previously entered form data.
        $data = Factory::getApplication()->getUserState('com_eventgallery.edit.order.data', array());
        if (empty($data)) {
            $data = $this->getItem()->_getInternalDataObject();
        }
        return $data;
    }

    /**
     * @param string $pk
     * @return bool|mixed|Order
     */
    public function getItem($pk = null)
    {
        $pk = (!empty($pk)) ? $pk : $this->getState($this->getName() . '.id');
        $table = $this->getTable();

        if ($pk > 0)
        {
            // Attempt to load the row.
            $return = $table->load($pk);

            // Check for a table object error.
            if ($return === false && $table->getError())
            {
                $this->setError($table->getError());
                return false;
            }
        }

        // Convert to the JObject before adding other data.
        $properties = $table->getProperties(1);

        $item = ArrayHelper::toObject($properties);

        if (property_exists($item, 'params'))
        {
            $registry = new Registry($item->params);
            $item->params = $registry->toArray();
        }


        /**
         * @var OrderFactory $orderFactory
         */
        $orderFactory = OrderFactory::getInstance();

        return $orderFactory->getOrderById($item->id);

    }

    protected function populateState()
    {
        $table = $this->getTable();
        $key = $table->getKeyName();

        // Get the pk of the record from the request.
        $pk = Factory::getApplication()->input->getString($key);
        $this->setState($this->getName() . '.id', $pk);

        // Load the parameters.
        $value = ComponentHelper::getParams($this->option);
        $this->setState('params', $value);
    }

    /**
     * Method to save the form data.
     *
     * @param   array  $data  The form data.
     *
     * @return  boolean  True on success, False on error.
     *
     * @since   12.2
     */
    public function save($data)
    {
        #$dispatcher = JEventDispatcher::getInstance();
        $table = $this->getTable();

        $key = $table->getKeyName();
        $pk = (!empty($data[$key])) ? $data[$key] : $this->getState($this->getName() . '.id');
        $isNew = true;

        // Include the content plugins for the on save events.
        PluginHelper::importPlugin('content');

        // Allow an exception to be thrown.
        try
        {
            // Load the row if saving an existing record.
            if ($pk > 0)
            {
                $table->load($pk);
                $isNew = false;
            }

            // Bind the data.
            if (!$table->bind($data))
            {
                $this->setError($table->getError());
                return false;
            }

            // Prepare the row for saving
            $this->prepareTable($table);

            // Check the data.
            if (!$table->check())
            {
                $this->setError($table->getError());
                return false;
            }

            // Trigger the onContentBeforeSave event.
            /*$result = $dispatcher->trigger($this->event_before_save, array($this->option . '.' . $this->name, $table, $isNew));
            if (in_array(false, $result, true))
            {
                $this->setError($table->getError());
                return false;
            }*/

            // Store the data.
            if (!$table->store())
            {
                $this->setError($table->getError());
                return false;
            }

            // Clean the cache.
            $this->cleanCache();

            // Trigger the onContentAfterSave event.
            #$dispatcher->trigger($this->event_after_save, array($this->option . '.' . $this->name, $table, $isNew));
        }
        catch (\Exception $e)
        {
            $this->setError($e->getMessage());

            return false;
        }

        $pkName = $table->getKeyName();

        if (isset($table->$pkName))
        {
            $this->setState($this->getName() . '.id', $table->$pkName);
        }
        $this->setState($this->getName() . '.new', $isNew);

        return true;
    }

    public function delete(&$pks) {

        $pks = (array) $pks;
        $table = $this->getTable();

        // Iterate the items to delete each one.
        foreach ($pks as $i => $pk)
        {

            if ($table->load($pk))
            {
                if ($this->canDelete($table))
                {
                    if (!$table->delete($pk))
                    {
                        $this->setError($table->getError());
                        return false;
                    }

                    // remove lineitems
                    $db = Factory::getDbo();
                    $query = $db->getQuery(true)
                        ->delete($db->quoteName('#__eventgallery_imagelineitem'))
                        ->where('lineitemcontainerid=' . $db->quote($pk));
                    $db->setQuery($query);
                    $db->execute();

                    //remove servicelineitems
                    $db = Factory::getDbo();
                    $query = $db->getQuery(true)
                        ->delete($db->quoteName('#__eventgallery_servicelineitem'))
                        ->where('lineitemcontainerid=' . $db->quote($pk));
                    $db->setQuery($query);
                    $db->execute();

                    //remove address
                    $db = Factory::getDbo();
                    $query = $db->getQuery(true)
                        ->delete($db->quoteName('#__eventgallery_staticaddress'))
                        ->where('id=' . $db->quote($table->billingaddressid));
                    $db->setQuery($query);
                    $db->execute();

                    //remove address
                    $db = Factory::getDbo();
                    $query = $db->getQuery(true)
                        ->delete($db->quoteName('#__eventgallery_staticaddress'))
                        ->where('id=' . $db->quote($table->shippingaddressid));
                    $db->setQuery($query);
                    $db->execute();

                } else {
                    Log::add(Text::_('JLIB_APPLICATION_ERROR_DELETE_NOT_PERMITTED'), Log::WARNING, 'jerror');
                    return false;
                }
            }
            else
            {
                $this->setError($table->getError());
                return false;
            }
        }

        $this->cleanCache();
        return true;
    }

}
