<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Model;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\AdminModel;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\OrderStatusFactory;
use Svenbluege\Component\Eventgallery\Site\Library\OrderStatus;
defined('_JEXEC') or die();

class OrderstatusModel extends AdminModel
{
    protected $text_prefix = 'COM_EVENTGALLERY';


    /**
     * Method to get the record form.
     *
     * @param array $data An optional array of data for the form to interogate.
     * @param boolean $loadData True if the form is to load its own data (default case), false if not.
     * @return JForm A JForm object on success, false on failure
     */
    public function getForm($data = array(), $loadData = true)
    {
        // Initialise variables.

        /**
         * @var OrderStatusFactory $orderStatusFactory
         */

        $orderStatusFactory = OrderStatusFactory::getInstance();


        // Get the form.
        $form = $this->loadForm('com_eventgallery.orderstatus', 'orderstatus', array('control' => 'jform', 'load_data' => $loadData));

        if (empty($form)) {
            return false;
        }



        if ( $form->getValue('id')!=null ) {
            $orderstatus = $orderStatusFactory->getOrderStatusById($form->getValue('id'));
            if ($orderstatus->isSystemManaged()) {
                $form->setFieldAttribute('name', 'required', 'false');
                $form->setFieldAttribute('name', 'disabled', 'true');
            }
        }

        // the name field is required if we create a new order status
        if( !isset($data['id'])) {
            $form->setFieldAttribute('name', 'required', 'true');
        }

        return $form;
    }

    protected function loadFormData()
    {

        /**
         * @var OrderStatusFactory $orderStatusFactory
         */

        $orderStatusFactory = OrderStatusFactory::getInstance();

        // Check the session for previously entered form data.
        $data = Factory::getApplication()->getUserState('com_eventgallery.edit.orderstatus.data', array());

        if (empty($data))
        {
            $data = $this->getItem();
        } else {
            if (isset($data['id']) ) {
                $orderstatus =  $orderStatusFactory->getOrderStatusById($data['id']);
                $data['name'] = $orderstatus->getName();
            }
        }

		if (method_exists($this, 'preprocessData')) {
        	$this->preprocessData('com_eventgallery.orderstatus', $data);
		}

        return $data;
    }

     public function setDefault($pks, $value) {

        /**
         * @var OrderStatusFactory $orderStatusFactory
         */

        $orderStatusFactory = OrderStatusFactory::getInstance();


        $id = $pks[0];

        $orderStatus = $orderStatusFactory->getOrderStatusById($id);

        if ($orderStatus->isSystemManaged()) {
            Factory::getApplication()->enqueueMessage(\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDERSTATUS_EDIT_SYSTEMMANAGED_ERROR'), 'error');
            return false;
        }

        if (!$orderStatus->getType()==OrderStatus::TYPE_ORDER) {
            Factory::getApplication()->enqueueMessage(\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDERSTATUS_SETDEFAULT_FOR_NONORDER_ERROR'), 'error');
            return false;
        }

        if ($value==1) {

            $db = Factory::getDbo();
            $query = $db->getQuery(true);
            $query->update('#__eventgallery_orderstatus');
            $query->set($db->quoteName('default') . ' = 0');
            $query->where('type='.$db->quote($orderStatus->getType()));

            $db->setQuery($query);
            $db->execute();

            $db = Factory::getDbo();
            $query = $db->getQuery(true);
            $query->update('#__eventgallery_orderstatus');
            $query->set($db->quoteName('default') . ' = 1');
            $query->where('type='.$db->quote($orderStatus->getType()));
            $query->where('id='.$db->quote($id));

            $db->setQuery($query);
            $db->execute();

        }
        return true;

    }

    public function delete(&$pks) {

        /**
         * @var OrderStatusFactory $orderStatusFactory
         */

        $orderStatusFactory = OrderStatusFactory::getInstance();


        $newPks = array();

        foreach($pks as $pk) {
            $orderstatus = $orderStatusFactory->getOrderStatusById($pk);
            if (!$orderstatus->isSystemManaged()) {
                $newPks[] = $pk;
            }
        }


        if (!parent::delete($newPks)) {
            return false;
        }


        foreach($newPks as $pk) {

            $db = Factory::getDbo();
            $query = $db->getQuery(true);
            $query->update('#__eventgallery_order');
            $query->set('orderstatusid = null');
            $query->where('orderstatusid = '.$db->quote($pk));
            $db->setQuery($query);
            $db->execute();

            $db = Factory::getDbo();
            $query = $db->getQuery(true);
            $query->update('#__eventgallery_order');
            $query->set('paymentstatusid = null');
            $query->where('paymentstatusid = '.$db->quote($pk));
            $db->setQuery($query);
            $db->execute();

            $db = Factory::getDbo();
            $query = $db->getQuery(true);
            $query->update('#__eventgallery_order');
            $query->set('shippingstatusid = null');
            $query->where('shippingstatusid = '.$db->quote($pk));
            $db->setQuery($query);
            $db->execute();
        }

        return true;
    }

    protected function prepareTable($table)
    {
        // Set ordering to the last item if not set
        if (empty($table->ordering))
        {
            $db = $this->getDbo();
            $query = $db->getQuery(true)
                ->select('MAX(ordering)')
                ->from('#__eventgallery_orderstatus');

            $db->setQuery($query);
            $max = $db->loadResult();

            $table->ordering = $max + 1;
        }
    }

}
