<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Model;

use Joomla\CMS\MVC\Model\ListModel;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FileFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderFactory;
use Svenbluege\Component\Eventgallery\Site\Library\File\File;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\AddResult;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\LocalFolder;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\S3Folder;
use Svenbluege\Component\Eventgallery\Site\Library\Manager\FolderManager;

defined('_JEXEC') or die();

class SyncModel extends ListModel
{

    /**
     * adds new folders to the databases
     * @return AddResult[]
     */
    public function findNewFolders() {
        /**
         * @var FolderManager $folderMgr
         */
        $folderMgr = FolderManager::getInstance();
        return $folderMgr->findNewFolders();

    }

    /*
    * returns the folders
    * @return Folder[]
    */
    public function getFolders() {
        /**
         * @var FolderFactory $folderFactory
         */

        $filter = function ($folder) {
            /**
             * @var Folder $folder
             */
            if ($folder->getFolderType()->getId() == LocalFolder::ID || $folder->getFolderType()->getId() == S3Folder::ID) {
                return true;
            }
            return false;
        };

        $folderFactory = FolderFactory::getInstance();
        $allFolders = $folderFactory->getAllFolders();
        if (!is_iterable($allFolders)) return [];
        return array_filter($allFolders, $filter);
    }

    /**
     * @param string $foldername
     * @param string $filename
     * @return array
     */
    public function syncFile($foldername, $filename) {
        /**
         * @var FileFactory $fileFactory
         * @var File $file
         */
        $fileFactory = FileFactory::getInstance();
        $file = $fileFactory->getFile($foldername, $filename);

        $syncResult = FolderManager::$SYNC_STATUS_FAILED;
        $error = "";

        try {
            if (null != $file) {
                $syncResult = $file->syncFile();
            }
        } catch (\Exception $e) {
            $error = $e->getMessage();
        }

        $result = "";

        if ($syncResult == FolderManager::$SYNC_STATUS_NOSYNC) {
            $result = "nosync";
        }

        if ($syncResult == FolderManager::$SYNC_STATUS_SYNC)  {
            $result = "sync";
        }

        if ($syncResult == FolderManager::$SYNC_STATUS_DELTED)  {
            $result = "deleted";
        }

        if ($syncResult == FolderManager::$SYNC_STATUS_FAILED)  {
            $result = "failed";
        }

        return ['sync' => $result,
            'foldername' => $foldername,
            'filename' => $filename,
            'id' => $file->getId(),
            'error' => $error
        ];
    }

    /*
    * syncs a folder and returns the status
    */
    public function syncFolder($folder, $foldertype, $use_htacces_to_protect_original_files) {

        /**
         * @var FolderFactory $folderFactory
         * @var Folder $folderClass
         */
        $folderFactory = FolderFactory::getInstance();
        $folderObject = $folderFactory->getFolder($folder);

        if ($folderObject == null) {
            /**
             * @var $folderMgr FolderManager
             */
            $folderMgr = FolderManager::getInstance();
            $folderMgr->addNewFolder($folder, $foldertype);
            $folderObject = $folderFactory->getFolder($folder);
        }

        $folderClass = $folderObject->getFolderType()->getFolderHandlerClassname();
        $syncResult = $folderClass::syncFolder($folder, $use_htacces_to_protect_original_files);

        $result = ["status"=>"", "files" => isset($syncResult['files'])?$syncResult['files']:array()];

        if ($syncResult['status'] == FolderManager::$SYNC_STATUS_NOSYNC) {
            $result['status'] = "nosync";
        }

        if ($syncResult['status'] == FolderManager::$SYNC_STATUS_SYNC)  {
            $result['status'] = "sync";
        }

        if ($syncResult['status'] == FolderManager::$SYNC_STATUS_DELTED)  {
            $result['status'] = "deleted";
        }

        return $result;
    }
}
