<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Model;

use Svenbluege\Component\Eventgallery\Site\Library\Factory\FileFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderFactory;
use Svenbluege\Component\Eventgallery\Site\Library\File\File;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\Folder;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\LocalFolder;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\S3Folder;

defined('_JEXEC') or die();

class ThumbnailgeneratorModel extends SyncModel
{

    /**
     * @param $folderTypes int[]
     * @return Folder[]
     */
    public function getFolders($folderTypeIds = [LocalFolder::ID, S3Folder::ID]) {
        /**
         * @var FolderFactory $folderFactory
         */
        $folderFactory = FolderFactory::getInstance();

        return array_filter($folderFactory->getAllFolders(),  function(Folder $folder) use ($folderTypeIds) {
            if (in_array($folder->getFolderType()->getId(), $folderTypeIds)) {
                return true;
            }
            return false;
        });
    }

    /**
     * get all filenames which need new thumbnails
     *
     * @param $foldername
     * @return File[]
     */
    public function getFilesToSync($foldername, $saveETagOfThumbnailsToDatabase = false) {
        /**
         * @var FolderFactory $folderFactory
         * @var Folder $folder
         */
        $folderFactory = FolderFactory::getInstance();
        $folder = $folderFactory->getFolder($foldername);
        return $folder->getFilesToSync($saveETagOfThumbnailsToDatabase);
    }

    /**
     * create a thumbnail for the given file
     *
     * @param $folder
     * @param $file
     * @return int[]
     */
    public function createThumbnails($folder, $file) {

        /**
         * @var FileFactory $fileFactory
         * @var File $fileObject
         */
        $fileFactory = FileFactory::getInstance();
        $fileObject = $fileFactory->getFile($folder, $file);
        return $fileObject->createThumbnails();
    }
}
