<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Model;

use Joomla\CMS\Factory;
use Joomla\Filesystem\File;
use Joomla\Filesystem\Folder;
use Joomla\CMS\Language\Text;
use Svenbluege\Component\Eventgallery\Site\Library\Common\ImageProcessor;
use Svenbluege\Component\Eventgallery\Site\Library\Common\MediaHelper;
use Svenbluege\Component\Eventgallery\Site\Library\Exception\UnsupportedFileExtensionException;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FileFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderFactory;

defined('_JEXEC') or die();

class UploadModel extends FilesModel
{
    /**
     * @param string $folderStr
     * @throws \Exception
     */
  public function upload($folderStr, $doResizeUploadedFile) {
      $user = Factory::getApplication()->getIdentity();

      $canUpload = $user->authorise('core.edit','com_eventgallery');
      if (!$canUpload) {
          echo Text::_('COM_EVENTGALLERY_EVENT_UPLOAD_NO_PERMISSION');
          die();
      }

      $foldername=Folder::makeSafe($folderStr);

      /**
       * @var FolderFactory $folderFactory
       */
      $folderFactory = FolderFactory::getInstance();
      $folder = $folderFactory->getFolder($foldername);

      if ($folder == null) {
          throw new \Exception("Folder does not exist");
      }

      $file = null;

      $uploadedFile = Factory::getApplication()->input->files->get('file');
      if (!empty($uploadedFile)) {

          $filename = File::makeSafe($uploadedFile["name"]);
          $tmpFilename = $uploadedFile["tmp_name"];

          if (!in_array(strtolower(pathinfo($filename, PATHINFO_EXTENSION)), COM_EVENTGALLERY_ALLOWED_FILE_EXTENSIONS)) {
              $extension = pathinfo($filename, PATHINFO_EXTENSION);
              throw new UnsupportedFileExtensionException("$filename: Extension $extension not in in allowed extension list " . join(', ', COM_EVENTGALLERY_ALLOWED_FILE_EXTENSIONS));
          }

          $mediaHelper = new MediaHelper();
          $mime = $mediaHelper->getMimeType($tmpFilename, true);
          if (empty($mime) || !\in_array($mime, COM_EVENTGALLERY_ALLOWED_MIME_TYPES)) {
              throw new UnsupportedFileExtensionException("$filename: MimeType $mime not in in allowed list " . join(', ', COM_EVENTGALLERY_ALLOWED_MIME_TYPES));
          }

          if ($doResizeUploadedFile) {
              $config = \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main::getInstance();
              $joomlaConfig = Factory::getApplication()->getConfig();
              ImageProcessor::createThumbnailToFile($tmpFilename, $tmpFilename, $config, $config->getImage()->getResizeImageSize(), false, null, false, false);
          }

          $file = $folder->uploadImageFile($tmpFilename, $filename, $user);
          /**
           * @var FileFactory $fileFactory
           */
          $fileFactory = FileFactory::getInstance();
          $fileFactory->triggerContentChangeStateEvent($file->getFolderName(), $file->getFileName());

      }

      if ($file === null) {
          echo Text::_("COM_EVENTGALLERY_EVENT_UPLOAD_FAILED");
          die();
      }

      $htmlSafeFilename = htmlspecialchars($filename, ENT_QUOTES | ENT_HTML5, 'UTF-8');

      echo '<img alt="Done '. $htmlSafeFilename .'" class="img-thumbnail thumbnail" src="'.$file->getThumbUrl(240).'" />';
      if ($file->getExif()->hasError) {
        echo "<p>$htmlSafeFilename: ".Text::_("COM_EVENTGALLERY_EVENT_UPLOAD_EXIF_ERROR")."</p>";
      }

  }

}
