<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Model;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\AdminModel;

defined('_JEXEC') or die();






/** @noinspection PhpUndefinedClassInspection */
class WatermarkModel extends AdminModel
{

    public function getTable($type = 'Watermark', $prefix = '', $config = array())
    {
        return parent::getTable($type, $prefix, $config);
    }

    public function getForm($data = array(), $loadData = true) {

        $form = $this->loadForm('com_eventgallery.watermark', 'watermark', array('control' => 'jform', 'load_data' => $loadData));

        if (empty($form)){
            return false;
        }

        return $form;
    }

    protected function loadFormData()
    {
        // Check the session for previously entered form data.
        $data = Factory::getApplication()->getUserState('com_eventgallery.edit.watermark.data', array());

        if (empty($data))
        {
            $data = $this->getItem();
        }

		if (method_exists($this, 'preprocessData')) {
        	$this->preprocessData('com_eventgallery.watermark', $data);
        }

        return $data;
    }

    public function setDefault($pks, $value) {

        $id = $pks[0];

        // reset all
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->update('#__eventgallery_watermark');
        $query->set($db->quoteName('default') . ' = 0');


        $db->setQuery($query);
        $db->execute();

        if ($value==1) {

            $db = Factory::getDbo();
            $query = $db->getQuery(true);
            $query->update('#__eventgallery_watermark');
            $query->set($db->quoteName('default') . ' = 1');
            $query->where('id='.$db->quote($id));

            $db->setQuery($query);
            $db->execute();

        }
        return true;

    }

    protected function prepareTable($table)
    {
        // Set ordering to the last item if not set
        if (empty($table->ordering))
        {
            $db = $this->getDbo();
            $query = $db->getQuery(true)
                ->select('MAX(ordering)')
                ->from('#__eventgallery_watermark');

            $db->setQuery($query);
            $max = $db->loadResult();

            $table->ordering = $max + 1;
        }
    }

}
