<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Table;
use Joomla\CMS\Table\Table;
use Joomla\Database\DatabaseDriver;

defined('_JEXEC') or die('Restricted access');


class CartTable extends Table
{

    public $id;
    public $documentno;
    public $userid;
    public $email;
    public $phone;
    public $firstname;
    public $lastname;
    public $statusid;
    public $subtotal;
    public $subtotalcurrency;
    public $total;
    public $totalcurrency;
    public $surchargeid;
    public $paymentmethodid;
    public $shippingmethodid;
    public $billingaddressid;
    public $shippingaddressid;
    public $message;
    public $modified;
    public $created;
    public $newsletter_optin;

    /**
     * Constructor
     * @param DatabaseDriver $db
     */

	function __construct( &$db ) {
		parent::__construct('#__eventgallery_cart', 'id', $db);
	}
}
