<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Administrator\Table;
use Joomla\CMS\Table\Table;
use Joomla\Database\DatabaseDriver;
use Joomla\Registry\Registry;

defined('_JEXEC') or die('Restricted access');


class EmailtemplateTable extends Table
{
	public $id = null;
	public $key = null;
	public $subject = null;
	public $body = null;
	public $attachments = null;
	public $language = null;
	public $ordering = null;
	public $published = null;
	public $modified = null;
	public $created = null;

    /**
     * Constructor
     * @param DatabaseDriver $db
     */

	function __construct($db) {
		parent::__construct('#__eventgallery_emailtemplate', 'id', $db);
	}

    public function store($updateNulls = false) {
        $this->modified = date("Y-m-d H:i:s");
        return parent::store($updateNulls);
    }

	/**
	 * Overloaded bind function
	 *
	 * @param   array  $array   Named array
	 * @param   mixed  $ignore  An optional array or space separated list of properties
	 *                          to ignore while binding.
	 *
	 * @return  mixed  Null if operation was satisfactory, otherwise returns an error string
	 *
	 * @see     Table::bind
	 * @since   11.1
	 */
	public function bind($array, $ignore = '')
	{

		if ($array instanceof \stdClass ) {
			$array =  (array) $array;
		}

		if (isset($array['attachments']) && is_array($array['attachments']))
		{
			$registry = new Registry();
			$registry->loadArray($array['attachments']);
			$array['attachments'] = (string) $registry;
		}

		return parent::bind($array, $ignore);
	}
}
