<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Table;
use Joomla\CMS\Table\Table;
use Joomla\Database\DatabaseDriver;

defined('_JEXEC') or die('Restricted access');


class FlickraccountTable extends Table
{
    public $id;
    public $api_key;
    public $api_secret;
    public $user_id;
    public $auth_token;
    public $auth_token_secret;
    public $name;
    public $description;
    public $modified;
    public $created;
    public $published;
    public $ordering;

    /**
     * Constructor
     * @param DatabaseDriver $db
     */

	function __construct( &$db ) {
		parent::__construct('#__eventgallery_flickr_account', 'id', $db);
	}
    public function store( $updateNulls=false )
    {
        $this->user_id = trim($this->user_id);
        $this->api_key = trim($this->api_key);
        $this->api_secret = trim($this->api_secret);
        $this->auth_token = trim($this->auth_token);
        $this->auth_token_secret = trim($this->auth_token_secret);

        return parent::store($updateNulls);
    }

}
