<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Administrator\Table;
use Joomla\CMS\Factory;
use Joomla\CMS\Table\Table;
use Joomla\CMS\Tag\TaggableTableInterface;
use Joomla\CMS\Tag\TaggableTableTrait;
use Joomla\Registry\Registry;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderFactory;

defined('_JEXEC') or die('Restricted access');

class FolderTable extends Table implements TaggableTableInterface {

    use TaggableTableTrait;
    /**
     * Get the type alias for the history table
     *
     * @return  string  The alias as described above
     *
     * @since   4.0.0
     */
    public function getTypeAlias()
    {
        return $this->typeAlias;
    }

    public $id = null;
    public $folder = null;
    public $googlephotosaccountid = null;
    public $googlephotostitle = null;
    public $googlephotossharedpageurl = null;
    public $flickraccountid = null;
    public $flickrtitle = null;
    public $foldertags = null;
    public $date = null;
    public $description = null;
    public $published = null;
    public $publish_up = null;
    public $publish_down = null;
    public $text = null;
    public $hits = null;
    public $userid = null;
    public $ordering = null;
    public $password = null;
    public $passwordhint = null;
    public $cartable = null;
    public $imagetypesetid = null;
    public $watermarkid = null;
    public $modified = null;
    public $created = null;
    public $usergroupids = null;
    public $attribs = null;
    public $metadata = null;
    public $foldertypeid = null;
    public $sortattribute = null;
    public $sortdirection = null;
    public $shuffle_images = null;



    function __construct($db) {
        $this->typeAlias = 'com_eventgallery.event';
        parent::__construct('#__eventgallery_folder', 'id', $db);
    }

    public function check() {
        // Set publish_up to null if not set
        if (empty($this->publish_up))
        {
            $this->publish_up = null;
        }

        // Set publish_down to null if not set
        if (empty($this->publish_down))
        {
            $this->publish_down = null;
        }

        return parent::check();
    }

    public function store($updateNulls = true) {
        $this->modified = date("Y-m-d H:i:s");
        if (empty($this->id))
        {
            if (empty($this->created)) {
                $this->created = date("Y-m-d H:i:s");
            }
            // Set ordering to the last item if not set
            if (empty($this->ordering))
            {
                $db = Factory::getDbo();
                $db->setQuery('SELECT MAX(ordering) FROM #__eventgallery_folder');
                $max = $db->loadResult();

                $this->ordering = $max + 1;
            }
        }

        $this->watermarkid = (int)$this->watermarkid;
        $this->googlephotosaccountid = (int)$this->googlephotosaccountid;
        $this->flickraccountid = (int)$this->flickraccountid;
        // try to detect the CLI mode.
        if (array_key_exists('REQUEST_METHOD', $_SERVER))
        {
            $this->userid = Factory::getUser()->id;
        }
        $this->catid = (int)$this->catid;

        FolderFactory::clear();

        $result =  parent::store($updateNulls);

        /**
         * @var FolderFactory $factory
         */
        $factory = FolderFactory::getInstance();
        $folder = $factory->getFolderById($this->id);
        if ($folder != null) {
            $folder->getFiles();
        }

        return $result;
    }


    /**
     * Overloaded bind function
     *
     * @param   array  $array   Named array
     * @param   mixed  $ignore  An optional array or space separated list of properties
     *                          to ignore while binding.
     *
     * @return  mixed  Null if operation was satisfactory, otherwise returns an error string
     *
     * @see     Table::bind
     * @since   11.1
     */
    public function bind($array, $ignore = '')
    {

        if ($array instanceof \stdClass ) {
            $array =  (array) $array;
        }

        if (isset($array['attribs']) && is_array($array['attribs']))
        {
            $registry = new Registry();
            $registry->loadArray($array['attribs']);
            $array['attribs'] = (string) $registry;
        }

        if (isset($array['metadata']) && is_array($array['metadata']))
        {
            $registry = new Registry();
            $registry->loadArray($array['metadata']);
            $array['metadata'] = (string) $registry;
        }

        return parent::bind($array, $ignore);
    }
}
