<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\View\Cache;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Svenbluege\Component\Eventgallery\Administrator\Library\Common\View;

defined('_JEXEC') or die;

/** @noinspection PhpUndefinedClassInspection */
class HtmlView extends View
{

    protected $folders;

	function display($tpl = null)
	{

 		$this->folders = $this->get('Folders');

        $this->addToolbar();
		parent::display($tpl);
	}

	protected function addToolbar() {
        Factory::getApplication()->input->set('hidemainmenu', true);
		ToolbarHelper::title(   Text::_('COM_EVENTGALLERY_SUBMENU_CLEAR_CACHE') );

        $toolbar = Toolbar::getInstance('toolbar');
        $toolbar->appendButton('Link', 'th-large', 'COM_EVENTGALLERY_SUBMENU_EVENTGALLERY',   Route::_('index.php?option=com_cpanel&view=cpanel&dashboard=com_eventgallery.overview'), false);
	}
}

