<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\View\Downloadlog;
use Joomla\CMS\HTML\Helpers\Sidebar;
use Svenbluege\Component\Eventgallery\Administrator\Helper\EventgalleryHelper;
use Svenbluege\Component\Eventgallery\Administrator\Model\DownloadlogModel;
use Svenbluege\Component\Eventgallery\Site\Library\Common\Downloadlog;
use Svenbluege\Component\Eventgallery\Site\Library\Common\View;

defined('_JEXEC') or die;

class HtmlView extends View
{

    protected $items;
    protected $pagination;
    protected $state;

    /**
     * Display the view
     * @param null $tpl
     * @return bool|mixed
     */
    public function display($tpl = null)
    {
        $config = \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main::getInstance();
        if (!$config->getGeneral()->isDownloadLogEnabled()) {
            $app = \Joomla\CMS\Factory::getApplication();
            $app->enqueueMessage(\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_DOWNLOADLOG_NOT_ENABLED'), "warning");
        }

        $this->state = $this->get('State');
        $this->items = $this->get('Items');
        $this->pagination = $this->get('Pagination');

        // Check for errors.
        if (count($errors = $this->get('Errors'))) {
            throw new \Exception(implode("\n", $errors));
        }
        $this->addToolbar();
        return parent::display($tpl);
    }

    protected function addToolbar() {
        \Joomla\CMS\Toolbar\ToolbarHelper::title(   \Joomla\CMS\Language\Text::_( 'COM_EVENTGALLERY_DOWNLOADLOG' ), 'generic.png' );
        \Joomla\CMS\Toolbar\ToolbarHelper::link(\Joomla\CMS\Router\Route::_("index.php?option=com_eventgallery&task=downloadlog.export"), \Joomla\CMS\Language\Text::_( 'COM_EVENTGALLERY_DOWNLOADLOG_DOWNLOADBUTTON_ALT' ), "download");

        $options= [];
        foreach(Downloadlog::$TYPES as $key=>$value) {
            $options[] = \Joomla\CMS\HTML\HTMLHelper::_('select.option', $key, $value);
        }


        Sidebar::addFilter(
            \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_DOWNLOADLOG_TYPE'),
            'filter_type',
            \Joomla\CMS\HTML\HTMLHelper::_('select.options', $options, 'value', 'text', $this->state->get('filter.type'), true)
        );

        $options= [];
        $options[] = \Joomla\CMS\HTML\HTMLHelper::_('select.option', 'reg', 'COM_EVENTGALLERY_DOWNLOADLOG_USERTYPE_REG');
        $options[] = \Joomla\CMS\HTML\HTMLHelper::_('select.option', 'guest', 'COM_EVENTGALLERY_DOWNLOADLOG_USERTYPE_UNREG');

        Sidebar::addFilter(
            \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_DOWNLOADLOG_USERTYPE'),
            'filter_usertype',
            \Joomla\CMS\HTML\HTMLHelper::_('select.options', $options, 'value', 'text', $this->state->get('filter.usertype'), true)
        );

        $options= [];
        $options[] = \Joomla\CMS\HTML\HTMLHelper::_('select.option', 'yes', 'COM_EVENTGALLERY_DOWNLOADLOG_ISBOT_YES');
        $options[] = \Joomla\CMS\HTML\HTMLHelper::_('select.option', 'no', 'COM_EVENTGALLERY_DOWNLOADLOG_ISBOT_NO');

        Sidebar::addFilter(
            \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_DOWNLOADLOG_ISBOT'),
            'filter_isbot',
            \Joomla\CMS\HTML\HTMLHelper::_('select.options', $options, 'value', 'text', $this->state->get('filter.isbot'), true)
        );

        $options = [];
        for ($i = 2021; $i <= date("Y"); $i++) {
            $options[] = \Joomla\CMS\HTML\HTMLHelper::_('select.option', $i, $i);
        }

        Sidebar::addFilter(
            \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_DOWNLOADLOG_YEAR'),
            'filter_year',
            \Joomla\CMS\HTML\HTMLHelper::_('select.options', $options, 'value', 'text', $this->state->get('filter.year'), true)
        );

        $options = [];
        for ($i = 1; $i < 18; $i++) {
            $options[] = \Joomla\CMS\HTML\HTMLHelper::_('select.option', $i, DownloadlogModel::monthToString($i));
        }

        Sidebar::addFilter(
            \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_DOWNLOADLOG_MONTH'),
            'filter_month',
            \Joomla\CMS\HTML\HTMLHelper::_('select.options', $options, 'value', 'text', $this->state->get('filter.month'), true)
        );


    }

}
