<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\View\Emailtemplate;
use Svenbluege\Component\Eventgallery\Administrator\Library\Common\View;
use Svenbluege\Component\Eventgallery\Site\Library\Manager\EmailTemplateManager;

defined('_JEXEC') or die;


class RawView extends View
{
	protected $item;

    /**
     * Display the view
     * @param null $tpl
     * @return bool|mixed
     */
	public function display($tpl = null)
	{

		$this->item		= $this->get('Item');


        if ($this->getLayout()=="preview") {
            /**
             * @var EmailTemplateManager $emailtemplateMgr
             */
            $emailtemplateMgr = EmailTemplateManager::getInstance();

            $this->item->renderedSubject = $emailtemplateMgr->populate($this->item->subject, $this->item->demodata);
            $this->item->renderedBody = $emailtemplateMgr->populate($this->item->body, $this->item->demodata);
        }

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new \Exception(implode("\n", $errors));
		}

		return parent::display($tpl);
	}

}
