<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\View\Event;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Svenbluege\Component\Eventgallery\Administrator\Library\Common\View;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\Folder;

defined('_JEXEC') or die;


/** @noinspection PhpUndefinedClassInspection */
class HtmlView extends View
{
	protected $state;

	protected $item;

	protected $form;

	protected $folder;

    /**
     * Display the view
     * @param null $tpl
     * @return bool|mixed
     */
	public function display($tpl = null)
	{
		$this->state	= $this->get('State');
		$this->item		= $this->get('Item');
		$this->form		= $this->get('Form');

        /**
         * @var FolderFactory $folderFactory
         */
        $folderFactory = FolderFactory::getInstance();
        $this->folder = $folderFactory->getFolder($this->item->folder);

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new \Exception(implode("\n", $errors));
		}

		$this->addToolbar($this->folder);
		return parent::display($tpl);
	}

    /**
     * @param $folder Folder
     * @return void
     * @throws \Exception
     */
	private function addToolbar($folder) {
        Factory::getApplication()->input->set('hidemainmenu', true);
		$isNew		= ($this->item->id < 1);
		$text = $isNew ? Text::_( 'COM_EVENTGALLERY_NEW' ) : Text::_( 'COM_EVENTGALLERY_EDIT' );
        ToolbarHelper::title(   $text . ' ' . Text::_( 'COM_EVENTGALLERY_EVENT' ));

        $bar = Toolbar::getInstance('toolbar');

        ToolbarHelper::apply('event.apply');
		ToolbarHelper::save('event.save');
		if ($isNew)  {
			ToolbarHelper::cancel( 'event.cancel' );
		} else {
			ToolbarHelper::save2copy('event.save2copy');
			ToolbarHelper::cancel( 'event.cancel', Text::_( 'JTOOLBAR_CLOSE' ) );

            ToolbarHelper::spacer(100);
            $bar->appendButton('Link', 'folder', 'COM_EVENTGALLERY_BUTTON_FILES_DESC',   Route::_('index.php?option=com_eventgallery&view=files&folderid='.$this->item->id), false);
            if ($this->folder->supportsFileUpload() == true) {
                $bar->appendButton('Link', 'upload', 'COM_EVENTGALLERY_BUTTON_UPLOAD_DESC',  Route::_('index.php?option=com_eventgallery&view=upload&folderid=' . $this->item->id), false);
            }

            $resetHitsButton = $bar->confirmButton('icon-images', 'COM_EVENTGALLERY_BUTTON_RESET_EVENT_HITS', 'event.resethits');
            $resetHitsButton->setOption('button_class', 'button-delete btn btn-danger ');
            $resetHitsButton->setOption('message', Text::sprintf('COM_EVENTGALLERY_BUTTON_RESET_EVENT_HITS_MESSAGE', $folder->getHits()));
            $resetHitsButton->setOption('listCheck', false);


		}
	}

}
