<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Administrator\View\Eventgallery;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\Helpers\Sidebar;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Svenbluege\Component\Eventgallery\Administrator\Helper\EventgalleryHelper;
use Svenbluege\Component\Eventgallery\Administrator\Library\Common\View;
use Svenbluege\Component\Eventgallery\Administrator\Model\EventgalleryModel;

defined('_JEXEC') or die();

/** @noinspection PhpUndefinedClassInspection */
class HtmlView extends View
{

    public $updateSiteId = null;
    public $needsDownloadId = false;

	function display($tpl = null)
	{
        $app = Factory::getApplication();
        /**
         * @var EventgalleryModel $model
         */
        $model = $this->getModel();
        if (EVENTGALLERY_EXTENDED) {
            $config = \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main::getInstance();

            $this->needsDownloadId = $model->needsDownloadId();
            $this->updateSiteId = $model->getUpdateSiteId();
        }

		$this->addToolbar();
		parent::display($tpl);
	}

	protected function addToolbar() {
        $toolbar = Toolbar::getInstance('toolbar');
        $toolbar->appendButton('Link', 'th-large', 'COM_EVENTGALLERY_SUBMENU_EVENTGALLERY',   Route::_('index.php?option=com_cpanel&view=cpanel&dashboard=com_eventgallery.overview'), false);


        ToolbarHelper::title(   EventgalleryHelper::getTitle() . " ". EVENTGALLERY_VERSION . ' (build ' . EVENTGALLERY_VERSION_SHORTSHA . ')', 'generic.png' );


        $toolbar->appendButton('Link', 'trash', 'COM_EVENTGALLERY_SUBMENU_CLEAR_CACHE',  Route::_('index.php?option=com_eventgallery&view=cache'), false);
		$toolbar->appendButton('Link', 'checkin', 'COM_EVENTGALLERY_SUBMENU_SYNC_DATABASE',  Route::_('index.php?option=com_eventgallery&view=sync'), false);
        $toolbar->appendButton('Link', 'checkin', 'COM_EVENTGALLERY_SUBMENU_THUMBNAILGENERATOR',  Route::_('index.php?option=com_eventgallery&view=thumbnailgenerator'), false);

        ToolbarHelper::preferences('com_eventgallery', '550');
	}
}

