<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\View\Events;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\Helpers\Sidebar;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Toolbar\Button\ConfirmButton;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarButton;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Svenbluege\Component\Eventgallery\Administrator\Helper\EventgalleryHelper;
use Svenbluege\Component\Eventgallery\Administrator\Library\Common\View;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderTypeFactory;
use Svenbluege\Component\Eventgallery\Site\Library\FolderType;

defined('_JEXEC') or die();

/** @noinspection PhpUndefinedClassInspection */
class HtmlView extends View
{

	protected $items;
	protected $pagination;
    protected $state;

	function display($tpl = null)
	{
        $app = Factory::getApplication();

		// Get data from the model
        $this->state = $this->get('State');
        $this->items = $this->get('Items');
        $this->pagination = $this->get('Pagination');

        // Check for errors.
        if (count($errors = $this->get('Errors'))) {
            throw new \Exception(implode("\n", $errors));
        }

        if (!in_array($this->getLayout(), ['modal', 'contentpluginbutton', 'imagecontentpluginbutton'])) {
            $this->addToolbar();
        }

        return parent::display($tpl);
	}

	protected function addToolbar() {

        ToolbarHelper::title(   Text::_( 'COM_EVENTGALLERY_EVENTS' ), 'generic.png' );

        $toolbar = Toolbar::getInstance('toolbar');

        $toolbar->addNew('event.add');


        $dropdown = $toolbar->dropdownButton('status-group')
            ->text('JTOOLBAR_CHANGE_STATUS')
            ->toggleSplit(false)
            ->icon('icon-ellipsis-h')
            ->buttonClass('btn btn-action')
            ->listCheck(true);

        $childBar = $dropdown->getChildToolbar();

		$childBar->edit('event.edit');
		$childBar->publish('events.publish');
		$childBar->unpublish('events.unpublish');
        $childBar->publish('events.cartable','COM_EVENTGALLERY_EVENT_CARTABLE');
        $childBar->unpublish('events.notcartable','COM_EVENTGALLERY_EVENT_NOT_CARTABLE');

        $btn = new ConfirmButton();
        $btn->task('events.delete');
        $btn->message('COM_EVENTGALLERY_EVENT_CONFIRM_DELETION');
        $btn->buttonClass('dropdown-item');
        $btn->name('delete');
        $btn->text('JTOOLBAR_DELETE');
        $btn->icon('');
        $childBar->appendButton($btn);


        $toolbar->popupButton('batch')
            ->text('JTOOLBAR_BATCH')
            ->selector('collapseModal')
            ->listCheck(true);


		ToolbarHelper::preferences('com_eventgallery', '550');
		ToolbarHelper::spacer(100);
		// Add a trash button.

		$toolbar->appendButton('Link', 'trash', 'COM_EVENTGALLERY_SUBMENU_CLEAR_CACHE',   Route::_('index.php?option=com_eventgallery&view=cache'), false);
		$toolbar->appendButton('Link', 'checkin', 'COM_EVENTGALLERY_SUBMENU_SYNC_DATABASE',   Route::_('index.php?option=com_eventgallery&view=sync'), false);

        Sidebar::addFilter(
            Text::_('COM_EVENTGALLERY_EVENT_FILTER_TAG'),
            'filter_tag',
            HTMLHelper::_('select.options', HTMLHelper::_('tag.tags', array('filter.published' => array(1))), 'value', 'text', $this->state->get('filter.tag'), true)
        );

        /**
         * @var FolderTypeFactory $folderTypeFactory
         */
        $folderTypeFactory = FolderTypeFactory::getInstance();

        $options= array();
        /**
         * @var FolderType $folderType
         */
        foreach($folderTypeFactory->getFolderTypes(true) as $folderType) {
            $options[] = HTMLHelper::_('select.option', $folderType->getId(), $folderType->getDisplayName());
        }
        $options[] = HTMLHelper::_('select.option', '*', 'JALL');

        Sidebar::addFilter(
            Text::_('COM_EVENTGALLERY_EVENT_FILTER_TYPE'),
            'filter_type',
            HTMLHelper::_('select.options', $options, 'value', 'text', $this->state->get('filter.type'), true)
        );

        Sidebar::addFilter(
            Text::_('JOPTION_SELECT_CATEGORY'),
            'filter_category',
            HTMLHelper::_('select.options', HTMLHelper::_('category.options', 'com_eventgallery'), 'value', 'text', $this->state->get('filter.category'))
        );
	}

    /**
     * Returns an array of fields the table can be sorted by
     *
     * @return  array  Array containing the field name to sort by as the key and display text as value
     *
     * @since   3.0
     */
    protected function getSortFields()
    {
        return array(
            'folder' => Text::_('COM_EVENTGALLERY_EVENTS_FOLDERNAME'),
            'date' => Text::_('COM_EVENTGALLERY_EVENTS_EVENT_DATE'),
            'ordering' => Text::_('COM_EVENTGALLERY_EVENTS_ORDER'),
            'published' => Text::_('COM_EVENTGALLERY_EVENTS_PUBLISHED'),
            'cartable' => Text::_('COM_EVENTGALLERY_EVENTS_CARTABLE'),
            'hits' => Text::_('COM_EVENTGALLERY_EVENTS_HITS'),
            'catid' => Text::_('COM_EVENTGALLERY_EVENTS_CATEGORY'),
            'googlephotostitle' => Text::_('COM_EVENTGALLERY_EVENTS_GOOGLEPHOTOSTITLE'),
        );
    }
}

