<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\View\File;
use Joomla\CMS\Factory;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Svenbluege\Component\Eventgallery\Administrator\Library\Common\View;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FileFactory;

defined('_JEXEC') or die;

/** @noinspection PhpUndefinedClassInspection */
class HtmlView extends View
{
	protected $state;

	protected $item;

	protected $form;

    protected $file;

	protected $isModal;

    /**
     * Display the view
     * @param null $tpl
     * @return bool|mixed
     */
	public function display($tpl = null)
	{

		$this->state	= $this->get('State');
		$this->item		= $this->get('Item');
		$this->form		= $this->get('Form');

		$app = Factory::getApplication();

		$this->isModal = $app->input->getString('tmpl', 'default') == 'component';

        /**
         * @var FileFactory $fileFactory
         */
        $fileFactory = FileFactory::getInstance();
        $this->file = $fileFactory->getFile($this->item->folder, $this->item->file);

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new \Exception(implode("\n", $errors));
		}

		$this->addToolbar();

		if ($this->isModal) {
			$tpl = 'modal';
		}

		return parent::display($tpl);
	}

	protected function addToolbar() {
        Factory::getApplication()->input->set('hidemainmenu', true);
		$text = \Joomla\CMS\Language\Text::_( 'Edit' );

		ToolbarHelper::title(   $text . ' ' . \Joomla\CMS\Language\Text::_( 'COM_EVENTGALLERY_FILE' ) . ' ' . $this->item->file);

		ToolbarHelper::apply('file.apply');
		ToolbarHelper::save('file.save');
		ToolbarHelper::cancel('file.cancel', \Joomla\CMS\Language\Text::_('JTOOLBAR_CLOSE'));

	}

}
