<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\View\Files;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Uri\Uri;
use Svenbluege\Component\Eventgallery\Administrator\Library\Common\View;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\Folder;

defined('_JEXEC') or die;

class HtmlView extends View
{
    /**
     * @var Folder
     */
    protected $folder;
    protected $items;
    protected $pagination;
    protected $state;

    /**
     * @var \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main
     */
    protected $config;

    function display($tpl = null)
	{
        $this->folder = $this->get('Item');
        $this->state		= $this->get('State');
        $this->items		= $this->get('Items');
        $this->pagination	= $this->get('Pagination');
        $this->config = \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main::getInstance();

        // Check for errors.
        if (count($errors = $this->get('Errors')))
        {
            throw new \Exception(implode("\n", $errors));
        }

        $this->addToolbar();
        return parent::display($tpl);
	}

    protected function addToolbar() {
        Factory::getApplication()->input->set('hidemainmenu', true);
        $text = $this->folder->getFolderName();
        ToolbarHelper::title(   Text::_( 'COM_EVENTGALLERY_EVENT' ).":  $text" );

        $bar = Toolbar::getInstance('toolbar');

        $bar->appendButton('Link', 'cancel', 'JTOOLBAR_CLOSE',  Route::_('index.php?option=com_eventgallery&view=events'), false);

        if ($this->folder->supportsImageDataEditing()) {
            ToolbarHelper::custom('files.publish', 'icon-publish eg-active', '', '&nbsp;');
            ToolbarHelper::custom('files.unpublish', 'icon-publish');

            ToolbarHelper::custom('files.ismainimage', ' egfa egfa-star eg-active');
            ToolbarHelper::custom('files.isnotmainimage', ' egfa egfa-star');

            ToolbarHelper::custom('files.isnotmainimageonly', ' egfa egfa-table eg-active');
            ToolbarHelper::custom('files.ismainimageonly', ' egfa egfa-table');
        }

        ToolbarHelper::spacer(50);

        if ($this->folder->supportsFileDeletion()) {
            ToolbarHelper::deleteList(Text::_('COM_EVENTGALLERY_EVENT_IMAGE_ACTION_DELETE_ALERT'), 'files.delete', 'COM_EVENTGALLERY_EVENT_DELETE_IMAGES');
        }

        if ($this->folder->supportsThumbnailDeletion()) {
            $deleteThumbnailsButton = $bar->confirmButton('icon-images', 'COM_EVENTGALLERY_EVENT_DELETE_THUMBNAILS', 'files.deleteThumbnails');
            $deleteThumbnailsButton->setOption('button_class', 'button-delete btn btn-danger ');
            $deleteThumbnailsButton->setOption('message', 'COM_EVENTGALLERY_EVENT_DELETE_THUMBNAILS_ALERT');
            $deleteThumbnailsButton->setOption('listCheck', true);
        }

        if ($this->folder->isSortable()) {
            $bar->appendButton('Confirm', 'COM_EVENTGALLERY_EVENT_CLEAR_ORDERING_ALERT', 'trash', 'COM_EVENTGALLERY_EVENT_CLEAR_ORDERING', 'files.clearOrdering', false);
        }

        ToolbarHelper::spacer(100);
        $bar->appendButton('Link', 'edit', 'COM_EVENTGALLERY_BUTTON_EDIT_DESC',   Route::_('index.php?option=com_eventgallery&task=event.edit&id='.$this->folder->getId()), false);
        if ($this->folder->supportsFileUpload()) {
            $bar->appendButton('Link', 'upload', 'COM_EVENTGALLERY_BUTTON_UPLOAD_DESC',  Route::_('index.php?option=com_eventgallery&view=upload&folderid=' . $this->folder->getId()), false);
            $url = Uri::base().substr( Route::_('index.php?option=com_eventgallery&view=files&layout=sorting&tmpl=component&folderid='.$this->folder->getId()), strlen(Uri::base(true)) + 1);

            $bar->appendButton('Custom',

                '<a style="margin-left: 10px;" class="btn hasTooltip" data-toggle="modal" data-target="#file-sorting-modal" data-bs-toggle="modal" data-bs-target="#file-sorting-modal" title="'.Text::_('COM_EVENTGALLERY_FILE_SORTING_POPUP').'"><i class="icon-cog"></i> '.Text::_('COM_EVENTGALLERY_FILE_SORTING_POPUP').'</a>'
            );
        }

        if ($this->folder->supportsFileHitCount()) {
            $resetHitsButton = $bar->confirmButton('icon-images', 'COM_EVENTGALLERY_BUTTON_RESET_FILES_HITS', 'files.resethits');
            $resetHitsButton->setOption('button_class', 'button-delete btn btn-danger ');
            $resetHitsButton->setOption('message', Text::_('COM_EVENTGALLERY_BUTTON_RESET_FILES_HITS_MESSAGE'));
            $resetHitsButton->setOption('listCheck', false);
        }
    }
}
