<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\View\Googlephotos;
use Joomla\CMS\Factory;
use Svenbluege\Component\Eventgallery\Administrator\Library\Common\View;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\GooglePhotosAccountFactory;
use Svenbluege\Component\Eventgallery\Site\Library\GooglePhotosAccount;

defined('_JEXEC') or die;

class HtmlView extends View
{
    /**
     * @var GooglePhotosAccount
     */
    public $googlePhotosAccount;
    /**
     * Display the view
     * @param null $tpl
     * @return bool|mixed
     */
	public function display($tpl = null)
	{

        $app = Factory::getApplication();

        $id = $app->input->getInt('id');

        /**
         * @var GooglePhotosAccountFactory $accountFactory
         *
         */
        $accountFactory = GooglePhotosAccountFactory::getInstance();
        $this->googlePhotosAccount = $accountFactory->getAccountById($id);

        return parent::display($tpl);
	}
}
