<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\View\Messages;
use Joomla\CMS\HTML\Helpers\Sidebar;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Svenbluege\Component\Eventgallery\Administrator\Helper\EventgalleryHelper;
use Svenbluege\Component\Eventgallery\Administrator\Library\Common\View;
defined('_JEXEC') or die;

class HtmlView extends View
{

    protected $items;
    protected $pagination;
    protected $state;

    /**
     * Display the view
     * @param null $tpl
     * @return bool|mixed
     */
    public function display($tpl = null)
    {
        $this->state = $this->get('State');
        $this->items = $this->get('Items');
        $this->pagination = $this->get('Pagination');

        // Check for errors.
        if (count($errors = $this->get('Errors'))) {
            throw new \Exception(implode("\n", $errors));
        }
        $this->addToolbar();
        return parent::display($tpl);
    }

    protected function addToolbar() {
        ToolbarHelper::title(   Text::_( 'COM_EVENTGALLERY_MESSAGES' ), 'generic.png' );
        ToolbarHelper::deleteList('Remove all selected items?','messages.delete','Remove');
    }

}
