<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\View\Order;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Svenbluege\Component\Eventgallery\Administrator\Library\Common\View;

defined('_JEXEC') or die();





class HtmlView extends View
{

    /**
     * @var Form
     */
    protected $form;
    protected $item;
    protected $state;

    /**
     * Display the view
     * @param null $tpl
     * @return bool|mixed
     */
    public function display($tpl = null)
    {
        // Initialiase variables.
        $this->form = $this->get('Form');
        $this->item = $this->get('Item');
        $this->state = $this->get('State');

        $app = Factory::getApplication();

        $this->isModal = $app->input->getString('tmpl', 'default') == 'component';

        if ($this->isModal) {
            $tpl = 'modal';
        }
        // Check for errors.
        if (count($errors = $this->get('Errors'))) {
            throw new \Exception(implode("\n", $errors));
        }
        $this->addToolbar();
        return parent::display($tpl);
    }

    protected function addToolbar() {
        Factory::getApplication()->input->set('hidemainmenu', true);
        ToolbarHelper::title(  \Joomla\CMS\Language\Text::_( 'COM_EVENTGALLERY_ORDER' ) .' '. $this->item->getDocumentNumber() );

        ToolbarHelper::apply('order.apply');
        ToolbarHelper::save('order.save');
        ToolbarHelper::cancel( 'order.cancel' , \Joomla\CMS\Language\Text::_( 'JTOOLBAR_CLOSE' ));

        $bar = Toolbar::getInstance('toolbar');

        // Add a resend mail button.

        $bar->appendButton('Confirm', 'COM_EVENTGALLERY_ORDER_RESEND_MAIL_ALERT', 'mail', 'COM_EVENTGALLERY_ORDER_RESEND_MAIL',  'order.resendmail', false);
        $bar->appendButton('Standard', 'download', 'COM_EVENTGALLERY_ORDER_DOWNLOAD',  'order.download', false);


    }

}
