<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\View\Orders;
use Joomla\CMS\HTML\Helpers\Sidebar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Svenbluege\Component\Eventgallery\Administrator\Helper\EventgalleryHelper;
use Svenbluege\Component\Eventgallery\Administrator\Library\Common\View;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\OrderStatusFactory;
use Svenbluege\Component\Eventgallery\Site\Library\OrderStatus;

defined('_JEXEC') or die();




class HtmlView extends View
{

    protected $items;
    protected $pagination;
    protected $state;

    /**
     * Display the view
     * @param null $tpl
     * @return bool|mixed
     */
    public function display($tpl = null)
    {
        $this->state = $this->get('State');
        $this->items = $this->get('Items');
        $this->pagination = $this->get('Pagination');

        // Check for errors.
        if (count($errors = $this->get('Errors'))) {
            throw new \Exception(implode("\n", $errors));
        }

        $this->addToolbar();

        return parent::display($tpl);
    }

     protected function addToolbar() {
        ToolbarHelper::title(   \Joomla\CMS\Language\Text::_( 'COM_EVENTGALLERY_ORDERS' ), 'generic.png' );
        ToolbarHelper::deleteList(\Joomla\CMS\Language\Text::_( 'COM_EVENTGALLERY_ORDERS_REMOVE_ALERT' ),'orders.delete','Remove');

         // Build the active state filter options.
         $options = array();

         /**
          * @var OrderStatusFactory $orderstatusFactory
          * @var OrderStatus $orderstatus
          */
         $orderstatusFactory  = OrderStatusFactory::getInstance();

         /**
          * ORDER
          */
         $orderstatuses = $orderstatusFactory->getOrderStatuses(OrderStatus::TYPE_ORDER);

         foreach($orderstatuses as $orderstatus) {

             $options[] = \Joomla\CMS\HTML\HTMLHelper::_('select.option', $orderstatus->getId(), $orderstatus->getDisplayName());
         }

         $options[] = \Joomla\CMS\HTML\HTMLHelper::_('select.option', '*', 'JALL');

         Sidebar::addFilter(
             \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDER_ORDERSTATUS'),
             'filter_orderstatus',
             \Joomla\CMS\HTML\HTMLHelper::_('select.options', $options, 'value', 'text', $this->state->get('filter.orderstatus'), true)
         );

         /**
          * PAYMENT
          */
         $orderstatuses = $orderstatusFactory->getOrderStatuses(OrderStatus::TYPE_PAYMENT);
         $options = array();
         foreach($orderstatuses as $orderstatus) {

             $options[] = \Joomla\CMS\HTML\HTMLHelper::_('select.option', $orderstatus->getId(), $orderstatus->getDisplayName());
         }


         $options[] = \Joomla\CMS\HTML\HTMLHelper::_('select.option', '*', 'JALL');

         Sidebar::addFilter(
             \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDER_PAYMENTSTATUS'),
             'filter_paymentstatus',
             \Joomla\CMS\HTML\HTMLHelper::_('select.options', $options, 'value', 'text', $this->state->get('filter.paymentstatus'), true)
         );

         /**
          * SHIPPING
          */
         $orderstatuses = $orderstatusFactory->getOrderStatuses(OrderStatus::TYPE_SHIPPING);
         $options = array();
         foreach($orderstatuses as $orderstatus) {

             $options[] = \Joomla\CMS\HTML\HTMLHelper::_('select.option', $orderstatus->getId(), $orderstatus->getDisplayName());
         }


         $options[] = \Joomla\CMS\HTML\HTMLHelper::_('select.option', '*', 'JALL');

         Sidebar::addFilter(
             \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDER_SHIPPINGSTATUS'),
             'filter_shippingstatus',
             \Joomla\CMS\HTML\HTMLHelper::_('select.options', $options, 'value', 'text', $this->state->get('filter.shippingstatus'), true)
         );

    }

    /**
     * Returns an array of fields the table can be sorted by
     *
     * @return  array  Array containing the field name to sort by as the key and display text as value
     *
     * @since   3.0
     */
    protected function getSortFields()
    {
        return array(
            'documentno' => \Joomla\CMS\Language\Text::_('JGRID_HEADING_ID'),
            'orderstatusid' => \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDER_ORDERSTATUS'),
            'paymentstatusid' => \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDER_PAYMENTSTATUS'),
            'shippingstatusid' => \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDER_SHIPPINGSTATUS'),
            'total' => \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDER_TOTAL')
        );
    }


}
