<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\View\Shippingmethod;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Svenbluege\Component\Eventgallery\Administrator\Library\Common\View;
defined('_JEXEC') or die;

class HtmlView extends View
{
	protected $state;

	protected $item;

	protected $form;

    /**
     * Display the view
     * @param null $tpl
     * @return bool|mixed
     */
	public function display($tpl = null)
	{
		$this->state	= $this->get('State');
		$this->item		= $this->get('Item');
		$this->form		= $this->get('Form');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new \Exception(implode("\n", $errors));
		}

		$this->addToolbar();
		return parent::display($tpl);
	}

	private function addToolbar() {
        Factory::getApplication()->input->set('hidemainmenu', true);
		$isNew		= ($this->item->id < 1);
		$text = $isNew ? Text::_( 'COM_EVENTGALLERY_NEW' ) : Text::_( 'COM_EVENTGALLERY_EDIT' );
		ToolbarHelper::title(   $text . ' ' . Text::_( 'COM_EVENTGALLERY_SHIPPINGMETHOD' ));


		ToolbarHelper::apply('shippingmethod.apply');
		ToolbarHelper::save('shippingmethod.save');
		if ($isNew)  {
			ToolbarHelper::cancel( 'shippingmethod.cancel' );
		} else {
			ToolbarHelper::cancel( 'shippingmethod.cancel', Text::_( 'JTOOLBAR_CLOSE' ) );
		}


	}

}
