<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\View\Systemcheck;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\Helpers\Sidebar;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Svenbluege\Component\Eventgallery\Administrator\Helper\EventgalleryHelper;
use Svenbluege\Component\Eventgallery\Administrator\Library\Common\View;
use Svenbluege\Component\Eventgallery\Administrator\Model\SystemcheckModel;

defined('_JEXEC') or die();


class HtmlView extends View
{

    /**
     * @var \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main
     */
	protected $config;
	protected $schemaversions;
	protected $installedextensions;
    protected $doShowLogs = false;

	function display($tpl = null)
	{
        /**
		 * @var SystemcheckModel $model
		 */
		$model = $this->getModel();
		$this->schemaversions = $model->getSchemaversions();
		$this->installedextensions = $model->getInstalledextensions();
		$this->changeset = $model->getChangeSet();
        $this->changeseterrors = $this->changeset->check();
        $app = Factory::getApplication();
        $this->doShowLogs = $app->input->getBool('showlogs', false);

		$this->config = \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main::getInstance();
		$this->addToolbar();
		parent::display($tpl);
	}

	protected function addToolbar() {
        Factory::getApplication()->input->set('hidemainmenu', true);
        $toolbar = Toolbar::getInstance('toolbar');
        $toolbar->appendButton('Link', 'th-large', 'COM_EVENTGALLERY_SUBMENU_EVENTGALLERY',   Route::_('index.php?option=com_cpanel&view=cpanel&dashboard=com_eventgallery.overview'), false);
		ToolbarHelper::title(   EventgalleryHelper::getTitle() . " ". EVENTGALLERY_VERSION . ' (build ' . EVENTGALLERY_VERSION_SHORTSHA . ')', 'generic.png' );

	}
}

