<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\View\Upload;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Svenbluege\Component\Eventgallery\Administrator\Library\Common\View;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\Folder;

defined('_JEXEC') or die;

class HtmlView extends View
{

    /**
     * @var Folder
     */
    protected $folder;

	function display($tpl = null)
	{
		$this->folder		= $this->get('Item');

		$this->addToolbar();
		parent::display($tpl);
	}

	protected function addToolbar() {
        Factory::getApplication()->input->set('hidemainmenu', true);
		ToolbarHelper::title(   Text::_( 'Event' ).': <small><small>[ upload ]</small></small>' );
		ToolbarHelper::cancel( 'upload.cancel', 'Close' );
		$bar = Toolbar::getInstance('toolbar');

		ToolbarHelper::spacer(100);
		$bar->appendButton('Link', 'folder', 'COM_EVENTGALLERY_BUTTON_FILES_DESC',   Route::_('index.php?option=com_eventgallery&view=files&folderid='.$this->folder->getId()), false);
		$bar->appendButton('Link', 'edit', 'COM_EVENTGALLERY_BUTTON_EDIT_DESC',   Route::_('index.php?option=com_eventgallery&task=event.edit&id='.$this->folder->getId()), false);

	}
}

