<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\View\Watermarkpreview;
use Joomla\CMS\Factory;
use Svenbluege\Component\Eventgallery\Administrator\Library\Common\View;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\WatermarkFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Watermark;

defined('_JEXEC') or die;




class HtmlView extends View
{

    function display($tpl=null)
    {
        $app = Factory::getApplication();
        $mode = $app->input->getString('mode', 'landscape');
        if ($mode == 'landscape') {
            $image_file = JPATH_SITE . '/media/com_eventgallery/backend/img/watermark-small-landscape.jpg';
        } else {
            $image_file = JPATH_SITE . '/media/com_eventgallery/backend/img/watermark-small-portrait.jpg';
        }

        $im_original = imagecreatefromjpeg($image_file);

        /**
         * @var WatermarkFactory $watermarkFactory
         * @var Watermark $watermark
         */
        $watermarkFactory = WatermarkFactory::getInstance();

        $watermark = $watermarkFactory->getWatermarkById($app->input->getInt('id'));
        if (null != $watermark) {
            $watermark->addWatermark($im_original, true);
        }

        header("Content-Type: image/jpeg");

        imagejpeg($im_original);

        die();
    }
}
