<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\HTML\Helpers\Sidebar;
use Joomla\CMS\Router\Route;
use Joomla\CMS\User\UserFactoryInterface;
use Svenbluege\Component\Eventgallery\Site\Library\Common\Downloadlog;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FileFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\OrderFactory;

defined('_JEXEC') or die('Restricted access');


/**
 * @var FileFactory $fileFactory
 */
$fileFactory = FileFactory::getInstance();

/**
 * @var OrderFactory $orderFactory
 */
$orderFactory = OrderFactory::getInstance();
?>



<form action="<?php echo Route::_('index.php?option=com_eventgallery&view=downloadlog'); ?>"
      method="post" name="adminForm" id="adminForm">

    <div id="j-main-container">
        <div class="btn-toolbar eg-filter-bar input-group">
            <?php foreach (Sidebar::getFilters() as $filter) : ?>
                <div class="filter-search btn-group pull-left">
                    <label for="<?php echo $filter['name']; ?>" class="sr-only"><?php echo $filter['label']; ?></label>
                    <select name="<?php echo $filter['name']; ?>" id="<?php echo $filter['name']; ?>" class="custom-select" onchange="this.form.submit()">
                        <?php if (!$filter['noDefault']) : ?>
                            <option value=""><?php echo $filter['label']; ?></option>
                        <?php endif; ?>
                        <?php echo $filter['options']; ?>
                    </select>
                </div>
            <?php endforeach; ?>

            <div class="btn-group hidden-phone">
                <label for="limit" class="element-invisible"><?php echo \Joomla\CMS\Language\Text::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC');?></label>
                <?php echo $this->pagination->getLimitBox(); ?>
            </div>

        </div>



        <table class="table">
            <thead>
                <tr>
                    <!--<th width="20">
                        <input type="checkbox" name="checkall-toggle" value="" title="<?php echo \Joomla\CMS\Language\Text::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
                    </th>-->
                    <th>
                        Image
                    </th>
                    <th>
                        Download Type
                    </th>
                    <th>
                        Bot
                    </th>
                    <th>
                        Details
                    </th>
                </tr>
            </thead>
            <tbody>
            <?php foreach ($this->items as $i => $item) :
                $file = null;
                try {
                    $file = $fileFactory->getFile($item->folder, $item->file);
                } catch (\Exception $e) {

                }
            ?>

                <tr class="row<?php echo $i % 2; ?>">
                    <!--
                    <td class="center">
                        <?php echo \Joomla\CMS\HTML\HTMLHelper::_('grid.id', $i, $item->id); ?>
                    </td>-->

                    <td>

                        <?php IF ($file != null): ?>
                            <?php echo $file->getFolder()->getDisplayName() ?>
                            <br>
                            <a href="<?php echo Route::_('index.php?option=com_eventgallery&view=file&id=' . $file->getId())?>">
                                <?php echo $file->getThumbImgTag(50, 50, 'eventgallery-image', false, null, false, false); ?>
                            </a>
                        <?php ELSE: ?>
                            <?php echo $item->folder; ?>/<?php echo $item->file; ?>
                        <?php ENDIF;?>

                    </td>
                    <td>
                        <small><?php echo $this->escape($item->created) ?></small><br />
                        <?php echo Downloadlog::getTypeDisplayName($this->escape($item->type)) ?>
                    </td>
                    <td>
                        <?php echo $item->isbot ? \Joomla\CMS\Language\Text::_('JYES'):\Joomla\CMS\Language\Text::_('JNO'); ?>
                    </td>
                    <td>


                        <?php
                        if (is_numeric($item->juserid)) {
                            echo "Joomla User<br>";
                            echo "<small>";
                                $user = \Joomla\CMS\Factory::getUser($item->juserid);
                                echo $this->escape($user->name);
                                echo "<br>";
                                echo $this->escape($user->email);
                                echo "<br>";
                                echo $this->escape($user->username);
                                echo "<br>";
                                echo $this->escape($item->userid);
                            echo "</small>";
                        }

                        if ($item->type == Downloadlog::TYPE_PURCHASE_FILE) {
                            echo "<div>Order<br>";
                            echo "<small>";

                            $order = $orderFactory->getOrderById($item->reference);
                            if ($order != null) {
                                echo $order->getEMail();
                                echo "<br>";
                                echo $order->getDocumentNumber();
                            }

                            echo "</small>";
                            echo "</div>";
                        }

                        ?>
                        <small><?php echo $this->escape($item->browser)?></small>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
        <div class="pagination pagination-toolbar">
            <?php echo $this->pagination->getPagesLinks(); ?>
        </div>
    </div>

    <?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
    <input type="hidden" name="task" value="" />
    <input type="hidden" name="boxchecked" value="0" />
    <input type="hidden" name="limitstart" value="<?php echo $this->pagination->limitstart; ?>" />

</form>
