<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die('Restricted access');

?>

<style type="text/css">
	.eventgallery-row {
		margin-bottom: 20px;
	}
</style>

<div id="j-main-container" class="eg-overview">
    <?php IF ($this->needsDownloadId):
        $updateSiteEditUrl = Route::_('index.php?option=com_installer&task=updatesite.edit&update_site_id=' . $this->updateSiteId); ?>
        <div class="row row-fluid eventgallery-row alert alert-primary">
            <span>
                <?php echo Text::sprintf('COM_EVENTGALLERY_OPTIONS_COMMON_DOWNLOADID_MISSING_WARNING', $updateSiteEditUrl);?>
            </span>
        </div>
    <?php ENDIF; ?>

    <div class="row row-fluid eventgallery-row alert alert-primary" style="display:none" id="alertformissingthumbnails">
        <span>
            <?php echo Text::sprintf('COM_EVENTGALLERY_OVERVIEW_NUMBER_OF_MISSING_THUMBNAILS_WARNING', Route::_('index.php?option=com_eventgallery&view=thumbnailgenerator'));?>
        </span>
    </div>

    <div class="row row-fluid eventgallery-row">
        <div class="span4 col-sm">
            <div class="card">
                <h2 class="card-header"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_EVENTS')?></h2>
                <div class="card-body">
                    <p><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_EVENTS_DESC')?>
                        <a href="<?php echo str_replace('administrator/', '', Uri::root().'index.php?option=com_eventgallery&view=events')?>"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_EVENTS_PREVIEW')?></a>
                    </p>
                    <a class="btn btn-primary" href="<?php echo Route::_('index.php?option=com_eventgallery&view=events')?>"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_EVENTS')?></a>
                </div>
            </div>
        </div>
        <div class="span4 col-sm">
            <div class="card">
                <h2 class="card-header"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_ORDERS')?></h2>
                <div class="card-body">
                    <p><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_ORDERS_DESC')?></p>
                    <a class="btn btn-primary" href="<?php echo Route::_('index.php?option=com_eventgallery&view=orders')?>"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_ORDERS')?></a>
                </div>
                <h2 class="card-header"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_DOWNLOADLOG')?></h2>
                <div class="card-body">
                    <p><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_DOWNLOADLOG_DESC')?></p>
                    <a class="btn btn-primary" href="<?php echo Route::_('index.php?option=com_eventgallery&view=downloadlog')?>"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_DOWNLOADLOG')?></a>
                </div>
            </div>
        </div>
        <div class="span4 col-sm">
            <div class="card">
                <h2 class="card-header"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_DOCUMENTATION')?></h2>
                <div class="card-body">
                    <p><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_DOCUMENTATION_DESC')?></p>
                    <a class="btn btn-primary" href="<?php echo Route::_('index.php?option=com_eventgallery&view=documentation')?>"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_DOCUMENTATION')?></a>
                </div>
            </div>
        </div>
    </div>

    <?php IF (!EVENTGALLERY_EXTENDED):?>
        <div class="row-fluid">
            <div class="span12">
                <div class="card">
                    <div class="card-body">
                        <div class="alert alert-success">
                           <?php echo $this->loadSnippet('eventgallery_extended_hint')?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php ENDIF ?>

    <hr>

    <div class="row row-fluid eventgallery-row">

        <div class="span4 col-sm">
            <div class="card">
                <h2 class="card-header"><?php echo Text::_('COM_EVENTGALLERY_OVERVIEW_STATISTICS')?></h2>
                <div class="card-body">
                    <dl class="dl-horizontal row">
                        <dt class="col-sm-3"><?php echo Text::_('COM_EVENTGALLERY_OVERVIEW_STATISTICS_EVENTS')?></dt><dd class="col-sm-9"><?php echo $this->get('FolderCount')?></dd>
                        <dt class="col-sm-3"><?php echo Text::_('COM_EVENTGALLERY_OVERVIEW_STATISTICS_FILES')?></dt><dd class="col-sm-9"><?php echo $this->get('FileCount')?> (<?php echo $this->get('FileTotalCount')?>, <a title="<?php echo Text::_('COM_EVENTGALLERY_OVERVIEW_STATISTICS_FILES_CLEANUP_TITLE')?>" href="<?php echo Route::_('index.php?option=com_eventgallery&task=eventgallery.removeOldFiles')?>"><?php echo Text::_('COM_EVENTGALLERY_OVERVIEW_STATISTICS_FILES_CLEANUP')?></a>)</dd>
                        <dt class="col-sm-3"><?php echo Text::_('COM_EVENTGALLERY_OVERVIEW_STATISTICS_CARTS')?></dt><dd class="col-sm-9"><?php echo $this->get('CartCount')?> (<a title="<?php echo Text::_('COM_EVENTGALLERY_OVERVIEW_STATISTICS_CARTS_CLEANUP_TITLE')?>" href="<?php echo Route::_('index.php?option=com_eventgallery&task=eventgallery.removeOldCarts')?>"><?php echo Text::_('COM_EVENTGALLERY_OVERVIEW_STATISTICS_CARTS_CLEANUP')?></a>) </dd>
                        <dt class="col-sm-3"><?php echo Text::_('COM_EVENTGALLERY_OVERVIEW_STATISTICS_ORDERS')?></dt><dd class="col-sm-9"><?php echo $this->get('OrderCount')?></dd>
                        <dt class="col-sm-3"><?php echo Text::_('COM_EVENTGALLERY_OVERVIEW_STATISTICS_DOWNLOADS')?></dt><dd class="col-sm-9"><?php echo $this->get('DownloadlogCount')?></dd>
                        <dt class="col-sm-3"><?php echo Text::_('COM_EVENTGALLERY_OVERVIEW_STATISTICS_IMAGEHITS')?></dt><dd class="col-sm-9"><?php echo $this->get('ImageHitCount')?></dd>
                        <dt class="col-sm-3"><?php echo Text::_('COM_EVENTGALLERY_OVERVIEW_NUMBER_OF_MISSING_THUMBNAILS')?></dt><dd id="numberofmissingthumbnails" class="col-sm-9"><?php echo Text::_('COM_EVENTGALLERY_OVERVIEW_NUMBER_OF_MISSING_THUMBNAILS_LOADING');?></dd>
                        <script>
                            fetch('<?php echo Route::_('index.php?option=com_eventgallery&task=rest.numberofmissingthumbnails&format=raw', false)?>')
                                .then(response => response.json())
                                .then(data => {
                                    console.log(data)
                                    document.getElementById('numberofmissingthumbnails').innerText = data.numberOfMissingThumbnails;
                                    if (data.numberOfMissingThumbnails>0) {
                                        document.getElementById('alertformissingthumbnails').style.display = 'block';
                                    }
                                });
                        </script>
                    </dl>
                </div>
            </div>
        </div>
        <div class="span4 col-sm">
            <div class="card">
                <h2 class="card-header"><?php echo Text::_('COM_EVENTGALLERY_SUPPORT_TITLE')?></h2>
                <div class="card-body">
                    <p>
                        <?php echo Text::_('COM_EVENTGALLERY_SUPPORT_CONTENT1')?>
                         <a target="_blank" href="https://www.svenbluege.de">www.svenbluege.de</a>.
                    </p>
                    <p>
                        <?php echo Text::_('COM_EVENTGALLERY_SUPPORT_CONTENT2')?>
                         <a target="_blank" href="https://www.svenbluege.de/support"><?php echo Text::_('COM_EVENTGALLERY_SUPPORT_TRACKER')?></a>
                    </p>
                </div>
            </div>
        </div>
        <div class="span4 col-sm">
            <div class="card">
                <h2 class="card-header"><?php echo Text::_('COM_EVENTGALLERY_NEWSLETTER_TITLE')?></h2>
                <div class="card-body">
                    <p>
                        <?php echo Text::_('COM_EVENTGALLERY_NEWSLETTER_SIGNUP')?><br>
                    </p>
                    <p>
                        <a class="btn btn-primary" target="_blank" href="https://eepurl.com/dt-rfH"><?php echo Text::_('COM_EVENTGALLERY_NEWSLETTER_SUBMIT')?></a>
                    </p>
                </div>
            </div>
        </div>

    </div>

    <div style="clear:both;"></div>

    <hr>

    <div class="row row-fluid eventgallery-row">
        <div class="span4 col-sm">
            <div class="card">
                <h2 class="card-header"><?php echo Text::_('COM_EVENTGALLERY_GETTING_STARTED_HEADLINE')?></h2>
                <div class="card-body">
                    <p>
                        <iframe style="max-width: 100%;" width="560" height="315" src="https://www.youtube-nocookie.com/embed/thBzzk-LTl4" frameborder="0" allow="encrypted-media" allowfullscreen></iframe>
                    </p>
                </div>
            </div>
        </div>
        <div class="span4 col-sm">
            <div class="card">
                <h2 class="card-header"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_WATERMARKS')?></h2>
                <div class="card-body">
                    <p><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_WATERMARKS_DESC')?></p>
                    <a class="btn btn-default btn-secondary" href="<?php echo Route::_('index.php?option=com_eventgallery&view=watermarks')?>"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_WATERMARKS')?></a>
                </div>
            </div>
        </div>
        <div class="span4 col-sm">
            <div class="card">
                <h2 class="card-header"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_CATEGORIES')?></h2>
                <div class="card-body">
                    <p><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_CATEGORIES_DESC')?></p>
                    <a class="btn btn-default btn-secondary" href="<?php echo Route::_('index.php?option=com_categories&view=categories&extension=com_eventgallery')?>"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_CATEGORIES')?></a>
                </div>
            </div>
        </div>
    </div>

    <div style="clear:both;"></div>
    <hr>

    <div class="row row-fluid eventgallery-row">
        <div class="span4 col-sm">
            <div class="card">
                <h2 class="card-header"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_IMAGETYPES')?></h2>
                <div class="card-body">
                    <p><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_IMAGETYPES_DESC')?></p>
                    <a class="btn btn-default btn-secondary" href="<?php echo Route::_('index.php?option=com_eventgallery&view=imagetypes')?>"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_IMAGETYPES')?></a>
                </div>
            </div>
        </div>
        <div class="span4 col-sm">
            <div class="card">
                <h2 class="card-header"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_IMAGETYPEGROUPS')?></h2>
                <div class="card-body">
                    <p><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_IMAGETYPEGROUPS_DESC')?></p>
                    <a class="btn btn-default btn-secondary" href="<?php echo Route::_('index.php?option=com_eventgallery&view=imagetypes')?>"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_IMAGETYPES')?></a>
                </div>
            </div>
        </div>
        <div class="span4 col-sm">
            <div class="card">
                <h2 class="card-header"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_IMAGETYPESETS')?></h2>
                <div class="card-body">
                    <p><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_IMAGETYPESETS_DESC')?></p>
                    <a class="btn btn-default btn-secondary" href="<?php echo Route::_('index.php?option=com_eventgallery&view=imagetypesets')?>"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_IMAGETYPESETS')?></a>
                </div>
            </div>
        </div>
    </div>

    <div class="row row-fluid eventgallery-row">

        <div class="span4 col-sm">
            <div class="card">
                <h2 class="card-header"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_SURCHARGES')?></h2>
                <div class="card-body">
                    <p><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_SURCHARGES_DESC')?></p>
                    <a class="btn btn-default btn-secondary" href="<?php echo Route::_('index.php?option=com_eventgallery&view=surcharges')?>"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_SURCHARGES')?></a>
                </div>
            </div>
        </div>
        <div class="span4 col-sm">
            <div class="card">
                <h2 class="card-header"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_SHIPPINGMETHODS')?></h2>
                <div class="card-body">
                    <p><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_SHIPPINGMETHODS_DESC')?></p>
                    <a class="btn btn-default btn-secondary" href="<?php echo Route::_('index.php?option=com_eventgallery&view=shippingmethods')?>"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_SHIPPINGMETHODS')?></a>
                </div>
            </div>
        </div>
        <div class="span4 col-sm">
            <div class="card">
                <h2 class="card-header"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_PAYMENTMETHODS')?></h2>
                <div class="card-body">
                    <p><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_PAYMENTMETHODS_DESC')?></p>
                    <a class="btn btn-default btn-secondary" href="<?php echo Route::_('index.php?option=com_eventgallery&view=paymentmethods')?>"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_PAYMENTMETHODS')?></a>
                </div>
            </div>
        </div>
    </div>

    <div class="row row-fluid eventgallery-row">

        <div class="span4 col-sm">
            <div class="card">
                <h2 class="card-header"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_EMAILTEMPLATES')?></h2>
                <div class="card-body">
                    <p><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_EMAILTEMPLATES_DESC')?></p>
                    <a class="btn btn-default btn-secondary" href="<?php echo Route::_('index.php?option=com_eventgallery&view=emailtemplates')?>"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_EMAILTEMPLATES')?></a>
                </div>
            </div>
        </div>
        <div class="span4 col-sm">
            <div class="card">
                <h2 class="card-header"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_ORDERSTATUSES')?></h2>
                <div class="card-body">
                    <p><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_ORDERSTATUSES_DESC')?></p>
                    <a class="btn btn-default btn-secondary" href="<?php echo Route::_('index.php?option=com_eventgallery&view=orderstatuses')?>"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_ORDERSTATUSES')?></a>
                </div>
            </div>
        </div>
        <div class="span4 col-sm">
        </div>
    </div>

    <div class="row row-fluid eventgallery-row">

        <div class="span4 col-sm">
            <div class="card">
                <h2 class="card-header"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_GOOGLEPHOTOSACCOUNTS')?></h2>
                <div class="card-body">
                    <p><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_GOOGLEPHOTOSACCOUNTS_DESC')?></p>
                    <a class="btn btn-default btn-secondary" href="<?php echo Route::_('index.php?option=com_eventgallery&view=googlephotosaccounts')?>"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_GOOGLEPHOTOSACCOUNTS')?></a>
                </div>
            </div>
        </div>
        <div class="span4 col-sm">
            <div class="card">
                <h2 class="card-header"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_FLICKRACCOUNTS')?></h2>
                <div class="card-body">
                    <p><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_FLICKRACCOUNTS_DESC')?></p>
                    <a class="btn btn-default btn-secondary" href="<?php echo Route::_('index.php?option=com_eventgallery&view=flickraccounts')?>"><?php echo Text::_('COM_EVENTGALLERY_SUBMENU_FLICKRACCOUNTS')?></a>
                </div>
            </div>
        </div>
        <div class="span4 col-sm">
        </div>
    </div>

</div>

<form action="<?php echo Route::_('index.php'); ?>" method="post" id="adminForm" name="adminForm">
    <input type="hidden" name="option" value="com_eventgallery" />
    <input type="hidden" name="task" value="" />
    <?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
</form>
