<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\Helpers\Sidebar;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Administrator\Table\FolderTable;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\FlickrFolder;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\GooglePhotosFolder;
use Svenbluege\Component\Eventgallery\Site\Library\Helper\UserGroups;

defined('_JEXEC') or die('Restricted access');

\Joomla\CMS\HTML\HTMLHelper::_('bootstrap.tooltip');
\Joomla\CMS\HTML\HTMLHelper::_('behavior.multiselect');

$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
$sortFields = $this->getSortFields();


$saveOrder	= $listOrder == 'ordering';
if ($saveOrder)
{
    $saveOrderingUrl = 'index.php?option=com_eventgallery&task=events.saveOrderAjax&tmpl=component';
}

?>

<style>
    .foldername {
        display: block;
        max-width: 350px;
        word-wrap: break-word;
        font-family: "Courier New", Courier, monospace;
    }
</style>

<script type="text/javascript">
    document.addEventListener("DOMContentLoaded", function()  {
        Joomla.orderTable = function()
        {
            table = document.getElementById("sortTable");
            direction = document.getElementById("directionTable");
            order = table.options[table.selectedIndex].value;
            if (order != '<?php echo $listOrder; ?>')
            {
                dirn = 'desc';
            }
            else
            {
                dirn = direction.options[direction.selectedIndex].value;
            }
            Joomla.tableOrdering(order, dirn, '');
        }
    });
</script>
<form method="post" id="adminForm" name="adminForm">
        <div id="j-main-container">



            <div class="btn-toolbar eg-filter-bar input-group">
                <?php foreach (Sidebar::getFilters() as $filter) : ?>
                    <div class="filter-search btn-group">
                        <label for="<?php echo $filter['name']; ?>" class="sr-only"><?php echo $filter['label']; ?></label>
                        <select name="<?php echo $filter['name']; ?>" id="<?php echo $filter['name']; ?>" class="custom-select" onchange="this.form.submit()">
                            <?php if (!$filter['noDefault']) : ?>
                                <option value=""><?php echo $filter['label']; ?></option>
                            <?php endif; ?>
                            <?php echo $filter['options']; ?>
                        </select>
                    </div>
                <?php endforeach; ?>

                <div class="input-group">
                    <input class="form-control" type="text" name="filter_search" id="filter_search" placeholder="<?php echo Text::_('COM_EVENTGALLERY_EVENT_SEARCH_PLACEHOLDER'); ?>" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" title="<?php echo Text::_('COM_EVENTGALLERY_ORDERS_SEARCH_DESC'); ?>" />
                    <button class="btn btn-primary hasTooltip" type="submit" title="<?php echo Text::_('JSEARCH_FILTER_SUBMIT'); ?>"><i class="icon-search"></i></button>
                    <button class="btn btn-primary hasTooltip" type="button" title="<?php echo Text::_('JSEARCH_FILTER_CLEAR'); ?>" onclick="document.getElementById('filter_search').value='';this.form.submit();"><i class="icon-remove"></i></button>
                </div>

                <div class="btn-group hidden-phone">
                    <label for="limit" class="element-invisible"><?php echo Text::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC');?></label>
                    <?php echo $this->pagination->getLimitBox(); ?>
                </div>
                <div class="btn-group hidden-phone">
                    <label for="directionTable" class="element-invisible"><?php echo Text::_('JFIELD_ORDERING_DESC');?></label>
                    <select name="directionTable" id="directionTable" class="form-select input-medium" onchange="Joomla.orderTable()">
                        <option value=""><?php echo Text::_('JFIELD_ORDERING_DESC');?></option>
                        <option value="asc" <?php if ($listDirn == 'asc') echo 'selected="selected"'; ?>><?php echo Text::_('COM_EVENTGALLERY_ORDER_ASCENDING');?></option>
                        <option value="desc" <?php if ($listDirn == 'desc') echo 'selected="selected"'; ?>><?php echo Text::_('COM_EVENTGALLERY_ORDER_DESCENDING');?></option>
                    </select>
                </div>
                <div class="btn-group">
                    <label for="sortTable" class="element-invisible"><?php echo Text::_('COM_EVENTGALLERY_SORT_BY');?></label>
                    <select name="sortTable" id="sortTable" class="form-select input-medium" onchange="Joomla.orderTable()">
                        <option value=""><?php echo Text::_('COM_EVENTGALLERY_SORT_BY');?></option>
                        <?php echo \Joomla\CMS\HTML\HTMLHelper::_('select.options', $sortFields, 'value', 'text', $listOrder);?>
                    </select>
                </div>

            </div>

            <div class="alert alert-primary" style="display:none" id="alertformissingthumbnails">
                <?php echo Text::sprintf('COM_EVENTGALLERY_OVERVIEW_NUMBER_OF_MISSING_THUMBNAILS_WARNING', Route::_('index.php?option=com_eventgallery&view=thumbnailgenerator'));?>
            </div>

            <script>
                fetch('<?php echo Route::_('index.php?option=com_eventgallery&task=rest.numberofmissingthumbnails&format=raw', false)?>')
                    .then(response => response.json())
                    .then(data => {
                        if (data.numberOfMissingThumbnails>0) {
                            document.getElementById('alertformissingthumbnails').style.display = 'block';
                        }
                    });
            </script>
        <table class="adminlist table table-striped wrap-table" id="eventsList">
            <thead>
                <tr>
                    <th style="width: 20px">
                        <input type="checkbox" name="checkall-toggle" value="" title="<?php echo Text::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
                    </th>
                    <th class=""><?php echo Text::_('COM_EVENTGALLERY_EVENTS_ORDER')?>
                        <span style="font-weight: normal"><?php echo (new \Joomla\CMS\Layout\FileLayout('eventgallery.orderingsave'))->render(['task'=>'events.saveorder']); ?></span>
                    </th>
                    <th style="min-width: 70px; max-width: 240px;">&nbsp;
                        <?php echo Text::_( 'COM_EVENTGALLERY_EVENTS_MAINIMAGE' ); ?>
                    </th>
                    <th>
                        <?php echo Text::_( 'COM_EVENTGALLERY_EVENTS_FOLDERNAME' ); ?>
                    </th>

                    <th>
                        &nbsp;
                    </th>

                </tr>
            </thead>
            <?php

            for ($i=0, $n=count( $this->items ); $i < $n; $i++)
            {
                /**
                 * @var FolderTable $item
                 */
            $item = $this->items[$i];

            $item->tags = new \Joomla\CMS\Helper\TagsHelper();
            $tags = $item->tags->getItemTags('com_eventgallery.event', $item->id);

            $checked = \Joomla\CMS\HTML\HTMLHelper::_('grid.id', $i, $item->id);
            $editLink = Route::_('index.php?option=com_eventgallery&task=event.edit&id=' . $item->id);
            $uploadLink = Route::_('index.php?option=com_eventgallery&view=upload&folderid=' . $item->id);
            $filesLink = Route::_('index.php?option=com_eventgallery&view=files&folderid=' . $item->id);

            /**
             * @var FolderFactory $folderFactory
             */
            $folderFactory = FolderFactory::getInstance();
            $folder = $folderFactory->getFolder($item->folder);

            if (!isset($folder)) {
                continue;
            }

            ?>
            <tr class="">
                <td>
                    <?php echo $checked; ?>
                </td>
                <td class="eg-events-actions">
                    <div class="btn-group">
                        <?php IF ($item->published == 1): ?>
                        <?php
                            $nowDate = \Joomla\CMS\Factory::getDate()->toUnix();
                            $nullDate = \Joomla\CMS\Factory::getDbo()->getNullDate();
                            $publishUp = $item->publish_up;
                            $publishDown = $item->publish_down;

                            $tz = \Joomla\CMS\Factory::getUser()->getTimezone();

                            $publishUp   = ($publishUp !== null && $publishUp !== $nullDate) ? \Joomla\CMS\Factory::getDate($publishUp, 'UTC')->setTimeZone($tz) : false;
                            $publishDown = ($publishDown !== null && $publishDown !== $nullDate) ? \Joomla\CMS\Factory::getDate($publishDown, 'UTC')->setTimeZone($tz) : false;

                            $icon = 'publish';
                            $title = Text::_('COM_EVENTGALLERY_BUTTON_PUBLISHED_DESC');

                            if ($publishUp && $nowDate < $publishUp->toUnix())
                            {
                                $title = Text::_('JLIB_HTML_PUBLISHED_PENDING_ITEM');
                                $icon = 'pending';
                            }

                            if ($publishDown && $nowDate > $publishDown->toUnix())
                            {
                                $title = Text::_('JLIB_HTML_PUBLISHED_EXPIRED_ITEM');
                                $icon = 'expired';
                            }

                            // Create tip text, only we have publish up or down settings
                            $tips = array();

                            if ($publishUp)
                            {
                                $tips[] = Text::sprintf('JLIB_HTML_PUBLISHED_START', \Joomla\CMS\HTML\HTMLHelper::_('date', $publishUp, Text::_('DATE_FORMAT_LC5'), 'UTC'));
                            }

                            if ($publishDown)
                            {
                                $tips[] = Text::sprintf('JLIB_HTML_PUBLISHED_FINISHED', \Joomla\CMS\HTML\HTMLHelper::_('date', $publishDown, Text::_('DATE_FORMAT_LC5'), 'UTC'));
                            }

                            $title .= empty($tips) ? '' : ' ' . implode(', ', $tips);
                        ?>
                            <a title="<?php echo $title ?>"
                               style="color: green" class="btn btn-micro active" href="javascript:void(0);"
                               onclick="return Joomla.listItemTask('cb<?php echo $i; ?>','events.unpublish')">
                                <span class="state"><i class="icon-<?php echo $icon;?>"></i></span>
                            </a>
                        <?php ELSE: ?>
                            <a title="<?php echo Text::_('COM_EVENTGALLERY_BUTTON_UNPUBLISHED_DESC'); ?>"
                               style="color: red" class="btn btn-micro" href="javascript:void(0);"
                               onclick="return Joomla.listItemTask('cb<?php echo $i; ?>','events.publish')">
                                <span class="state"><i class="icon-unpublish"></i></span>
                            </a>
                        <?php ENDIF ?>


                        <?php IF ($item->cartable == 1): ?>
                            <a title="<?php echo Text::_('COM_EVENTGALLERY_BUTTON_CARTABLE_DESC'); ?>"
                               style="color: green" class="btn btn-micro active" href="javascript:void(0);"
                               onclick="return Joomla.listItemTask('cb<?php echo $i; ?>','events.notcartable')">
                                <span class="state"><i class="icon-cart"></i></span>
                            </a>
                        <?php ELSE: ?>
                            <a title="<?php echo Text::_('COM_EVENTGALLERY_BUTTON_UNCARTABLE_DESC'); ?>"
                               style="color: red" class="btn btn-micro" href="javascript:void(0);"
                               onclick="return Joomla.listItemTask('cb<?php echo $i; ?>','events.cartable')">
                                <span class="state"><i class="icon-cart"></i></span>
                            </a>
                        <?php ENDIF ?>
                    </div>
                    <div class="btn-group">
                        <?php IF ($folder->supportsFileUpload() == true) : ?>
                            <a title="<?php echo Text::_('COM_EVENTGALLERY_BUTTON_UPLOAD_DESC'); ?>"
                               href="<?php echo $uploadLink; ?>" id="upload_<?php echo $item->id ?>"
                               class="btn btn-micro">
                                <span class="state "><i class="icon-upload"></i>	<span class="text"></span></span>
                            </a>
                        <?php ENDIF; ?>
                        <a title="<?php echo Text::_('COM_EVENTGALLERY_BUTTON_FILES_DESC'); ?>"
                           href="<?php echo $filesLink; ?>" id="files_<?php echo $item->id ?>" class="btn btn-micro">
                            <span class="state"><i class="icon-folder-2"></i>	<span class="text"></span></span>
                        </a>

                        <a title="<?php echo Text::_('COM_EVENTGALLERY_BUTTON_EDIT_DESC'); ?>"
                           href="<?php echo $editLink; ?>" id="files_<?php echo $item->id ?>" class="btn btn-micro">
                            <span class="state"><i class="icon-edit"></i>	<span class="text"></span></span>
                        </a>

                    </div>
                    <?php echo (new \Joomla\CMS\Layout\FileLayout('eventgallery.orderingcontrolls'))->render(['reverseSorting'=>true, 'currentIndex' => $i, 'numberOfItems'=>$n, 'value'=>$item->ordering, 'pagination'=>$this->pagination, 'taskPrefix'=>'events']); ?>
                </td>
                <td class="eventimage">
                    <?php $files = $folder->getFiles(0,1, 1);
                    foreach($files as $file) {
                        echo '<a href="'.$editLink.'">';
                        echo '<img class="img-thumbnail thumbnail" src="'.$file->getThumbUrl(104).'" />';
                        echo '</a>';

                    }
                    ?>
                </td>
                <td class="wrap">
                        <span class="title"><?php echo $this->escape($folder->getDisplayName());?></span>
                        <br>
                        <span class="foldername">
                            <?php if ($folder->getFolderType()->getId() == GooglePhotosFolder::ID && !empty($folder->getGooglePhotosTitle())) {
                                /**
                                 * @var GooglePhotosFolder $folder
                                 */

                                    echo $this->escape($folder->getGooglePhotosTitle());
                            } elseif ($folder->getFolderType()->getId() == FlickrFolder::ID && !empty($folder->getFlickrTitle())) {
                                /**
                                 * @var FlickrFolder $folder
                                 */

                                echo $this->escape($folder->getFlickrTitle());
                            }
                            else  {
                                echo $folder->getFolderName();
                            }?>
                        </span>

                        <small>
                            <br><strong><?php echo Text::_('COM_EVENTGALLERY_EVENTS_EVENT_DATE'); ?></strong>: <?php echo \Joomla\CMS\HTML\HTMLHelper::date(empty($item->date)?'':$item->date, Text::_('DATE_FORMAT_LC3')); ?>
                            <br><strong><?php echo Text::_('COM_EVENTGALLERY_EVENTS_SOURCE'); ?></strong>: <?php echo $folder->getFolderType()->getDisplayName() ?>
                        </small>

                        <?php
                            if ( null != $folder->getWatermark() ) {
                                echo '<br><small><strong>'.Text::_( 'COM_EVENTGALLERY_EVENTS_WATERMARK' ).'</strong>: ';
                                echo $folder->getWatermark()->getName().'</small>';
                            }
                            if (null != $folder->getImageTypeSet()) {
                                echo '<br><small><strong>'.Text::_( 'COM_EVENTGALLERY_EVENTS_IMAGETYPESET' ).'</strong>: ';
                                echo $folder->getImageTypeSet()->getName().'</small>';
                            }
                        ?>
                        <?php
                        if ($folder->getFolderType()->getId() == \Svenbluege\Component\Eventgallery\Site\Library\Folder\GooglePhotosSharedPageFolder::ID) {
                            /**
                             * @var \Svenbluege\Component\Eventgallery\Site\Library\Folder\GooglePhotosSharedPageFolder $folder
                             */
                            echo "<br><small>URL:</small><a href='".$folder->getGooglePhotosSharedPageUrl()."' target='_blank'>Shared Page</a>";
                        }
                        ?>
                        <small>
                            <br><?php echo $folder->getFileCount();?> <?php echo Text::_('COM_EVENTGALLERY_EVENTS_FILECOUNT_FILES'); ?>,
                                <?php echo $folder->getHits();?> <?php echo Text::_('COM_EVENTGALLERY_EVENTS_HITS'); ?>
                        </small>
                    </td>


                    <td>
                        <small>
                            <?php IF (!empty($item->category_title)): ?>
                                <strong><?php echo Text::_( 'COM_EVENTGALLERY_EVENTS_CATEGORY' ); ?></strong>:
                                <?php echo $item->category_title; ?><br>
                            <?php ENDIF ?>
                            <?php IF (count($tags)>0): ?>
                                <strong><?php echo Text::_( 'COM_EVENTGALLERY_EVENTS_TAGS' ); ?></strong>:
                                <?php
                                    $tempTags = array();
                                    foreach($tags as $tag) {
                                        array_push($tempTags, $tag->title);
                                    }
                                    echo implode(', ', $tempTags);
                                ?>
                                <br>
                            <?php ENDIF ?>
                            <?php IF (!empty($item->password)): ?>
                                <strong><?php echo Text::_( 'COM_EVENTGALLERY_EVENTS_PASSWORD' ); ?></strong>:
                                <?php echo $this->escape($item->password); ?>
                                <br>
                            <?php ENDIF ?>
                            <?php IF (!empty($item->usergroupids) && $item->usergroupids!='1'): ?>
                                <strong><?php echo Text::_( 'COM_EVENTGALLERY_EVENTS_USERGROUPS' ); ?></strong>:
                                <?php
                                    $usergroupids = explode(',',$item->usergroupids);
                                    $groups = array();
                                    foreach($usergroupids as $usergroupid) {
                                        $groups[] = UserGroups::getUserGroupName($usergroupid);
                                    }
                                    echo implode(',', $groups);
                                ?>
                                <br>
                            <?php ENDIF ?>
                            <?php IF (!empty($item->attribs)): $attibs = json_decode($item->attribs);?>
                                <?php IF (isset ($attibs->download_original_images_usergroupids) && $attibs->download_original_images_usergroupids[0] != '1'): ?>
                                    <strong><?php echo Text::_( 'COM_EVENTGALLERY_EVENTS_DOWNLOAD_ORIGINALIMAGES_USERGROUPS' ); ?></strong>:
                                    <?php
                                    $usergroupids = $attibs->download_original_images_usergroupids;
                                    $groups = array();
                                    foreach($usergroupids as $usergroupid) {
                                        if (!empty($usergroupid)) {
                                            $groups[] = UserGroups::getUserGroupName($usergroupid);
                                        }
                                    }
                                    echo implode(',', $groups);
                                    ?>
                                    <br>
                                <?php ENDIF ?>
                            <?php ENDIF ?>
                        </small>
                        <small>
                            <strong><?php echo Text::_( 'COM_EVENTGALLERY_EVENTS_MODIFIED_BY' ); ?></strong>:
                            <?php $user = Factory::getUser($item->userid); echo $user->name;?>,
                            <?php echo Text::_( 'COM_EVENTGALLERY_EVENT_CREATED' ); ?> <?php echo \Joomla\CMS\HTML\HTMLHelper::date($item->created,Text::_('DATE_FORMAT_LC4')) ?>,
                            <?php echo Text::_( 'COM_EVENTGALLERY_EVENT_MODIFIED' ); ?> <?php echo \Joomla\CMS\HTML\HTMLHelper::date($item->modified,Text::_('DATE_FORMAT_LC4')) ?>
                        </small>
                    </td>

                </tr>
                <?php

            }
            ?>
            </table>
            <div class="pagination pagination-toolbar">
                <?php echo $this->pagination->getPagesLinks(); ?>
            </div>
        </div>


    <?php //Load the batch processing form. ?>
    <?php echo \Joomla\CMS\HTML\HTMLHelper::_(
        'bootstrap.renderModal',
        'collapseModal',
        array(
            'title'  => Text::_('COM_EVENTGALLERY_BATCH_OPTIONS'),
            'footer' => $this->loadTemplate('batch_footer'),
        ),
        $this->loadTemplate('batch_body')
    ); ?>


	<?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
    <input type="hidden" name="task" value="" />
    <input type="hidden" name="boxchecked" value="0" />
    <input type="hidden" name="limitstart" value="<?php echo $this->pagination->limitstart; ?>" />
    <input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
    <input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
	<input type="hidden" name="option" value="com_eventgallery" />

</form>
