<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Layout\LayoutHelper;

defined('_JEXEC') or die;


$published = $this->state->get('filter.published');
?>

            <div class="eg-modal-body">
                <p><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_BATCH_TIP'); ?></p>
                <div class="container">
                    <div class="row">
                        <div class="form-group control-group span6 col-md-6">
                            <div class="controls">
                                <?php echo LayoutHelper::render('eventgallery.batch.watermark', []); ?>
                            </div>
                        </div>
                        <div class="form-group control-group span6 col-md-6">
                            <div class="controls">
                                <?php echo LayoutHelper::render('eventgallery.batch.imagetypeset', []); ?>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group control-group span6 col-md-6">
                            <div class="controls">
                                <?php echo LayoutHelper::render('eventgallery.batch.usergroup', []); ?>
                            </div>
                        </div>
                        <div class="form-group control-group span6 col-md-6">
                            <div class="controls">
                                <?php echo LayoutHelper::render('eventgallery.batch.password', []); ?>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group control-group span6 col-md-6">
                            <div class="controls">
                                <?php echo LayoutHelper::render('eventgallery.batch.tags', []); ?>
                            </div>
                        </div>
                        <?php if ($published >= 0) : ?>
                            <div class="form-group control-group span6 col-md-6">
                                <div class="controls">
                                    <?php echo LayoutHelper::render('eventgallery.batch.categories', []); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
