<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FileFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\FlickrFolder;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\Folder;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\GooglePhotosFolder;

defined('_JEXEC') or die('Restricted access');
/**
 * @var \de\svenbluege\joomla\eventgallery\ObjectWithConfiguration $this
 */

$app = Factory::getApplication();

?>

<?php
	/**
	* adjust the image path
	*/
	$_image_script_path = 'components/com_eventgallery/helpers/image.php';

	if ($this->config->getImage()->doUseLegacyImageRendering()) {
		$_image_script_path = "index.php";
	}

    /**
     * @var Folder $folder
     */
    $folder = $this->folder;

	$listOrder	= $folder->getSortAttribute();
	$listDirn	= $folder->getSortDirection();

	if (empty($listOrder)) {
		$listOrder = $this->config->getEventsList()->getSortFilesByColumn();
	}
	if (empty($listDirn)) {
		$listDirn = $this->config->getEventsList()->getSortFilesByDirection();
	}


	$saveOrder	= $listOrder == 'ordering';


?>


<form method="POST" name="adminForm" id="adminForm">

    <div id="filter-bar" class="btn-toolbar eg-filter-bar">
        <div class="btn-group pull-right hidden-phone">
            <label for="limit" class="element-invisible"><?php echo Text::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC'); ?></label>
            <?php echo $this->pagination->getLimitBox(); ?>
        </div>
    </div>
    <div class="clearfix"> </div>

    <input type="hidden" name="option" value="com_eventgallery" />
    <input type="hidden" name="id" value="<?php echo $this->folder->getId(); ?>" />
    <input type="hidden" name="task" value="" />
    <?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>

    <input type="hidden" name="boxchecked" value="0" />
    <input type="hidden" name="folderid" value="<?php echo $this->folder->getId(); ?>" />

    <div class="card">
        <div class="card-body">
            <?php if ($folder->supportsImageDataEditing()): ?>
                <p>
                    <?php echo Text::sprintf('COM_EVENTGALLERY_FILES_ORDER_HELP', $listOrder, $listDirn); ?><br>
                    <?php echo Text::sprintf('COM_EVENTGALLERY_FILES_IMAGETYPESET_HELP', $folder->getImageTypeSet()?$folder->getImageTypeSet()->getName():''); ?>
                </p>
            <?php ELSE: ?>
                <p>
                    <?php echo Text::sprintf('COM_EVENTGALLERY_FILES_NO_EDITING_SUPPORT'); ?>
                </p>
            <?php ENDIF;?>

            <?php if (!EVENTGALLERY_EXTENDED && $folder->getFolderType()->getId() == GooglePhotosFolder::ID): ?>
                <p>
                    <?php echo Text::_('COM_EVENTGALLERY_GOOGLEPHOTOS_LIMITATIONS_HINT'); ?>
                </p>
            <?php ENDIF; ?>

            <?php if (!EVENTGALLERY_EXTENDED && $folder->getFolderType()->getId() == FlickrFolder::ID): ?>
                <p>
                    <?php echo Text::_('COM_EVENTGALLERY_FLICKR_LIMITATIONS_HINT'); ?>
                </p>
            <?php ENDIF; ?>
        </div>
    </div>
    <p></p>
    <table class="table table-striped adminlist">
    <thead>
        <tr>

            <th width="20">
                <input type="checkbox" name="checkall-toggle" value="" title="<?php echo Text::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
            </th>
            <th width="180">
                <?php echo Text::_( 'COM_EVENTGALLERY_EVENTS_FILENAME' ); ?>
            </th>
            <th width="130">
                <?php echo Text::_( 'COM_EVENTGALLERY_EVENTS_ORDER' ); ?>
                <?php IF ($folder->isSortable() && $saveOrder):?>
                    <?php echo (new \Joomla\CMS\Layout\FileLayout('eventgallery.orderingsave'))->render(['task'=>'files.saveorder']); ?>
                <?php ENDIF; ?>
            </th>
            <th width="1%">
                <?php echo Text::_( 'COM_EVENTGALLERY_EVENTS_OPTIONS' ); ?>
            </th>
            <th>
                <?php echo Text::_( 'COM_EVENTGALLERY_FILES_CONTENT' ); ?>
            </th>

            <?php IF ($folder->supportsImageDataEditing()):?>
                <th>
                    <?php echo Text::_( 'COM_EVENTGALLERY_FILES_HITS' ); ?>
                </th>
            <?php ENDIF; ?>
        </tr>
    </thead>
    <?php

    for ($i=0, $n=count( $this->items ); $i < $n; $i++)
    {
        $row = $this->items[$i];

        /**
         * @var FileFactory $fileFactory
         * @var \Svenbluege\Component\Eventgallery\Site\Library\File\File $file
         */

        $fileFactory = FileFactory::getInstance();
        $file = $fileFactory->getFile($row->folder, $row->file);

        $editLink =  Route::_('index.php?option=com_eventgallery&view=file&layout=edit&id='.$row->id);
        $editLinkAjax = $editLink . '&tmpl=component&format=raw';
        $checked 	= \Joomla\CMS\HTML\HTMLHelper::_('grid.id',   $i, $row->id );
        // TODO: remove due to strange issues with at least on joomla installation $published =  \Joomla\CMS\HTML\HTMLHelper::_('jgrid.published', $row->published, $i );

        $this->row = $row;
        $this->file = $file;
        $this->editLink = $editLink;
        $this->editLinkAjax = $editLinkAjax;
        ?>

        <tr>
            <td>
                <?php echo $checked; ?>
            </td>
            <td>
                <?php echo $this->loadSnippet('thumb.lightbox');?>
            </td>
            <td class="order">
                <?php IF ($file->getFolder()->isSortable() && $saveOrder): ?>
                    <?php echo (new \Joomla\CMS\Layout\FileLayout('eventgallery.orderingcontrolls'))->render(['reverseOrder'=>strtoupper($listDirn) == 'DESC','currentIndex' => $i, 'numberOfItems'=>$n, 'value'=>$row->ordering, 'pagination'=>$this->pagination, 'taskPrefix'=>'files']); ?>
                <?php ENDIF; ?>
                <div style="word-wrap: break-word; width: 120px">
                    <small style="word-wrap:break-word">
                        <?php echo $file->getFileName()?>
                        <br><?php $date = $file->getCreationDate(); echo $date==null?"":$date->format(Text::_('DATE_FORMAT_LC2'))?>
                    </small>

                </div>

            </td>
            <td>
                <div class="btn-group image-properies">
                    <?php IF ($file->getFolder()->supportsImageDataEditing()):?>
                        <a title="<?php echo Text::_( 'COM_EVENTGALLERY_EVENT_IMAGE_ACTION_PUBLISH' ); ?>"
                            onClick="return Joomla.listItemTask('cb<?php echo $i; ?>','<?php echo $row->published==0?"files.publish":"files.unpublish"; ?>')"
                            class="<?php echo $row->published==1? "btn btn-micro eg-active" : "btn btn-micro";?>">
                            <i class="icon-publish green"></i>
                        </a>

                        <a title="<?php echo Text::_( 'COM_EVENTGALLERY_EVENT_IMAGE_ACTION_MAINIMAGE' ); ?>" onClick="document.location.href='<?php echo  Route::_("index.php?option=com_eventgallery&view=files&task=".($row->ismainimage==0?"files.ismainimage":"files.isnotmainimage")."&folderid=".$this->folder->getId()."&cid[]=".$row->id."&limitstart=".$app->input->getInt('limitstart', '0')) ?>'"
                            class="<?php echo $row->ismainimage==1? "btn btn-micro eg-active" : "btn btn-micro";?>">
                            <i class="egfa egfa-star"></i>

                        </a>

                        <a title="<?php echo Text::_( 'COM_EVENTGALLERY_EVENT_IMAGE_ACTION_MAINIMAGEONLY' ); ?>" onClick="document.location.href='<?php echo  Route::_("index.php?option=com_eventgallery&view=files&task=".($row->ismainimageonly==0?"files.ismainimageonly":"files.isnotmainimageonly")."&folderid=".$this->folder->getId()."&cid[]=".$row->id."&limitstart=".$app->input->getInt('limitstart', '0')) ?>'"
                            class="<?php echo $row->ismainimageonly==0? "btn btn-micro eg-active" : "btn btn-micro";?>">
                            <i class="egfa egfa-table green"></i>
                        </a>
                        <?php IF ($file->getFolder()->supportsImageDataEditing()):?>
                            <a title="<?php echo Text::_('COM_EVENTGALLERY_EVENT_FILE_EDIT'); ?>"
                               data-qa-editlink href="<?php echo $this->editLink;?>"
                               class="btn btn-micro"
                            >
                                <i class="icon-edit"></i>
                            </a>
                        <?php ENDIF; ?>


                    <?php ENDIF; ?>
                </div>
            </td>
            <td>
                <div class="row-fluid" data-id="<?php echo $this->file->getId(); ?>" data-editlink="<?php echo $this->editLinkAjax; ?>">
                    <?php echo $this->loadTemplate('content'); ?>
                </div>
            </td>
            <?php IF ($file->getFolder()->supportsImageDataEditing()):?>
                <td>
                    <?php echo $file->getHitCount(); ?>
                </td>
            <?php ENDIF; ?>
        </tr>
        <?php
    }
    ?>
    </table>
    <input type="hidden" name="limitstart" value="<?php echo $this->pagination->limitstart; ?>" />
    <div class="pagination pagination-toolbar">
        <?php echo $this->pagination->getPagesLinks(); ?>
    </div>

    <?php //Load the batch processing form. ?>
    <?php echo \Joomla\CMS\HTML\HTMLHelper::_(
        'bootstrap.renderModal',
        'file-sorting-modal',
        array(
            'title'  => Text::_('COM_EVENTGALLERY_FILE_SORTING_POPUP'),
            'footer' => $this->loadTemplate('sorting_footer'),
        ),
        $this->loadTemplate('sorting_body')
    ); ?>

</form>
