<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Filter\InputFilter;
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die('Restricted access');

/**
 * @var \Svenbluege\Component\Eventgallery\Site\Library\File\File $file
 */
$file = $this->file;

$langs = \Joomla\CMS\Language\LanguageHelper::getKnownLanguages();

$defaultLanguageTag = \Joomla\CMS\Component\ComponentHelper::getParams('com_languages')->get('site');
$defaultLanguage = $langs[$defaultLanguageTag];
if ($defaultLanguage != null) {
    unset($langs[$defaultLanguageTag]);
    $langs = array_merge(array($defaultLanguageTag => $defaultLanguage), $langs);
}

$safeHtmlFilter = InputFilter::getInstance();
$contentFound = false;
?>


<small <?php IF ($file->getFolder()->supportsImageDataEditing()):?>class="openInlineForm"<?php ENDIF; ?>>

    <?php if (!empty($this->row->title)): $contentFound = true;?>
        <div class="title-content span4">
            <h4><?php echo Text::_('COM_EVENTGALLERY_EVENT_FILE_TITLE')?></h4>
            <dl>
                <?php foreach($langs as $tag=>$lang) {

                    $var = $safeHtmlFilter->clean($file->getFileTitle($tag), 4);


                    echo "<dt>$tag</strong></dt>";
                    echo "<dd>$var</dd>";
                }?>
            </dl>
        </div>
    <?php ENDIF; ?>
    <?php if (!empty($this->row->caption)): $contentFound = true;?>
        <div class="caption-content span7">
            <h4><?php echo Text::_('COM_EVENTGALLERY_EVENT_FILE_CAPTION')?></h4>
            <dl>
                <?php foreach($langs as $tag=>$lang) {
                    $var = $safeHtmlFilter->clean($file->getFileCaption($tag), 4);
                    echo "<dt>$tag</strong></dt>";
                    echo "<dd>$var</dd>";
                }?>
            </dl>
        </div>
    <?php ENDIF; ?>

    <?php if (!empty($file->getUrl())): $contentFound = true;?>
        <div class="row-fluid">
            <div class="url-content span11">
                <dl>
                    <dt><h4><?php echo Text::_('COM_EVENTGALLERY_FILE_URL')?></h4></dt>
                    <dd><?php echo $file->getUrl(); ?></dd>
                </dl>
            </div>
        </div>
    <?php ENDIF; ?>

    <?php if ($file->getImageTypeSet() != $file->getFolder()->getImageTypeSet()): ?>
        <div class="row-fluid">
            <div class="imagetypeset-content span11">
                <dl>
                    <dt><h4><?php echo Text::_('COM_EVENTGALLERY_EVENTS_IMAGETYPESET')?></h4></dt>
                    <dd><?php echo $file->getImageTypeSet()->getName(); ?></dd>
                </dl>
            </div>
        </div>
    <?php ENDIF; ?>


    <?php IF (!$contentFound && $file->getFolder()->supportsImageDataEditing()):?>
        <?php echo Text::_('COM_EVENTGALLERY_FILE_CLICK_TO_EDIT_LABEL')?>
    <?php ENDIF; ?>
</small>
