<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\FlickrAccount;

defined('_JEXEC') or die('Restricted access');
?>


<form action="<?php echo  Route::_('index.php?option=com_eventgallery&view=flickraccount'); ?>"
      method="post" name="adminForm" id="adminForm">
        <div id="j-main-container">
            <div class="card">
                <div class="card-body">
                    <p>
                        <iframe width="560" height="315" src="https://www.youtube-nocookie.com/embed/11HCvdWH6o8" frameborder="0" allow="encrypted-media" allowfullscreen></iframe>
                    </p>
                    <?php if (!EVENTGALLERY_EXTENDED): ?>
                    <p>
                        <?php echo Text::_('COM_EVENTGALLERY_FLICKR_LIMITATIONS_HINT'); ?>
                    </p>
                    <?php ENDIF ?>
                </div>
            </div>
            <p></p>

        <table class="table">
                <thead>
                    <tr>
                        <th width="20">
                            <input type="checkbox" name="checkall-toggle" value="" title="<?php echo Text::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
                        </th>
                        <th class="nowrap" width="1%">

                        </th>
                        <th>
                            <?php echo Text::_( 'COM_EVENTGALLERY_FLICKRACCOUNT_NAME' ); ?>
                        </th>
                        <th>
                            <?php echo Text::_( 'COM_EVENTGALLERY_FLICKRACCOUNT_ACCOUNTDATA' ); ?>
                        </th>
                        <th>
                            <?php echo Text::_( 'COM_EVENTGALLERY_FLICKRACCOUNT_PRIVATEDATAACCESS' ); ?>
                        </th>
                    </tr>
                </thead>


                <tbody>
                <?php $n=count($this->items); foreach ($this->items as $i => $item) :
                /**
                 * @var FlickrAccount $item;
                 */
                ?>

                    <tr class="row<?php echo $i % 2; ?>">
                        <td class="center">
                            <?php echo \Joomla\CMS\HTML\HTMLHelper::_('grid.id', $i, $item->getId()); ?>
                        </td>
                        <td>
                            <div class="btn-group">
                                <a title="<?php echo Text::_('COM_EVENTGALLERY_BUTTON_EDIT_DESC'); ?>" class="btn btn-micro" href="<?php echo
                                     Route::_('index.php?option=com_eventgallery&task=flickraccount.edit&id='.$item->getId()); ?>">
                                <i class="icon-edit"></i></a>
                            </div>
                        </td>
                        <td>
                                <?php echo $this->escape($item->getName()) ?>
                            <?php IF(!empty($item->getDescription())): ?>
                                <br><small><?php echo $this->escape($item->getDescription()) ?></small>
                            <?php ENDIF;?>

                        </td>
                        <td>
                            <?php if (!empty($item->getAPIKey())) echo $this->escape($item->getAPIKey())."<br>" ?>

                            <?php echo $this->escape($item->getUserId()) ?>
                        </td>
                        <td>

                            <?php echo Text::_($this->escape($item->isUsable())?"JYES":"JNO") ?>
                            <span class="account_validity" data-id="<?php echo $item->getId(); ?>"><?php Text::_('COM_EVENTGALLERY_FLICKR_VALIDITY_LOADING')?></span>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
            <div class="pagination pagination-toolbar">
                <?php echo $this->pagination->getPagesLinks(); ?>
            </div>

    </div>

    <?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
    <input type="hidden" name="task" value="" />
    <input type="hidden" name="boxchecked" value="0" />
    <input type="hidden" name="limitstart" value="<?php echo $this->pagination->limitstart; ?>" />


</form>

<script>
    (function() {
        let labelValid = ', <?php echo Text::_('COM_EVENTGALLERY_FLICKRACCOUNT_VALIDITY_VALID')?>';
        let labelInvalid = ', <?php echo Text::_('COM_EVENTGALLERY_FLICKRACCOUNT_VALIDITY_INVALID')?>';
        let elements = document.getElementsByClassName("account_validity");
        for (let i = 0; i < elements.length; i++) {
            let element = elements[i];
            let id = element.dataset.id;
            let url = '<?php  echo  Route::_('index.php?option=com_eventgallery&task=flickr.testAuthToken', false);?>&accountid=' + id;

            fetch(url)
                .then(response => response.json())
                .then(data => {
                    if (data.valid) {
                        element.innerHTML = labelValid;
                    } else {
                        element.innerHTML = '<b>' + labelInvalid + '</b>';

                    }
                });

        }
    })();



</script>
