<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Svenbluege\Component\Eventgallery\Site\Library\GooglePhotosAccount;

defined('_JEXEC') or die('Restricted access');

/**
 * @var \Joomla\CMS\Document\Document $document
 */
$document = Factory::getDocument();
$document->addScript('https://accounts.google.com/gsi/client?onload=eg_auth_init', [], ['async'=>false, 'defer'=>false]);
$app = \Joomla\CMS\Factory::getApplication();
$app->setHeader('cross-origin-opener-policy','unsafe-none', true);
/**
 * @var GooglePhotosAccount $googlePhotosAccount
 */
$googlePhotosAccount = $this->googlePhotosAccount;
$callbackUrl = \Joomla\CMS\Router\Route::_('index.php?option=com_eventgallery&task=googlephotosaccount.googlecallback', false, 1, true);
?>

<p>
    <?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_GOOGLEPHOTOS_SELECT_ACCOUNT_WHITELIST_REDIRECT_URL'); ?>
</p>
<p>
    <code>
        <strong><?php echo $callbackUrl ?></strong>
    </code>
</p>
<hr>
<p>
    <?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_GOOGLEPHOTOS_SELECT_ACCOUNT_WHY'); ?>
</p>
<p>
    <a class="btn btn-primary btn-large" onclick="client.requestCode();" id="signin" href="#"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_GOOGLEPHOTOS_SELECT_ACCOUNT') ?></a>
</p>


<p>
    <a href="<?php echo Joomla\CMS\Uri\Uri::root()?>/media/com_eventgallery/backend/img/google_photos_redirect_url.jpg" target="_blank"><img style="max-width:100%; width: 200px" src="<?php echo Joomla\CMS\Uri\Uri::root()?>/media/com_eventgallery/backend/img/google_photos_redirect_url.jpg"></a>
</p>

<script>
    const client = google.accounts.oauth2.initCodeClient({
        client_id: '<?php echo $googlePhotosAccount->getClientId()?>',
        scope: 'profile https://www.googleapis.com/auth/photoslibrary.readonly https://www.googleapis.com/auth/youtubepartner https://www.googleapis.com/auth/photospicker.mediaitems.readonly',
        ux_mode: 'redirect',
        access_type: 'offline',
        redirect_uri: '<?php echo $callbackUrl ?>',
        state: '<?php echo $googlePhotosAccount->getId(); ?>',
    });
   // client.requestCode();
</script>
