<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\GooglePhotosAccount;

defined('_JEXEC') or die('Restricted access');



?>

<form action="<?php echo  Route::_('index.php?option=com_eventgallery&view=googlephotosaccount'); ?>"
      method="post" name="adminForm" id="adminForm">

        <div id="j-main-container">

            <div id="filter-bar" class="btn-toolbar eg-filter-bar">
                <div class="btn-group pull-right hidden-phone">
                    <label for="limit" class="element-invisible"><?php echo Text::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC');?></label>
                </div>
            </div>
            <div class="clearfix"> </div>
            <div class="card">
                <div class="card-body">

                    <div class="alert alert-warning">
                        Dear Event Gallery Users,<br>
                        <br>
                        I need to inform you about upcoming changes to the Google Photos APIs that will impact how Event Gallery integrates with Google Photos.<br>
                        <br>
                        Unfortunately, as of <b>March 31, 2025</b>, Google is removing certain features that Event Gallery currently relies on.
                        This means that directly accessing Google Photos within Event Gallery will no longer be possible. Existing Events/albums will stop working. We know
                        this already from the changes to Picasa back than. Let's continue the cat&amp;mouse game!<br>
                        <br>
                        I'm actively exploring two potential solutions to ensure a smooth transition:<br>
                        Option 1: Use <a href="https://www.youtube.com/watch?v=Iw0K__AHsnQ">shared links</a>. This is already available and will support albums with up to 150 images.<br>
                        Option 2: I integrated the new Google Photos Picker. It allows you to select images from Google Photos and upload them to local webspace or an AWS S3 bucket.<br>
                        <br>
                        I appreciate your understanding and patience as I work through this.  Please don't hesitate to reach out if you have any questions or concerns.<br>
                        <br>
                        Thank you,<br>
                        Sven Bluege
                    </div>
                    <p>
                        <?php echo Text::_('COM_EVENTGALLERY_GOOGLEPHOTOSACCOUNTS_HELP'); ?>
                    </p>
                    <p>
                        <strong><?php echo Text::_('COM_EVENTGALLERY_GOOGLEPHOTOSACCOUNTS_HELP_PUBLISH_APP'); ?></strong>
                    </p>
                    <p>
                        <?php echo Text::_('COM_EVENTGALLERY_GOOGLEPHOTOSACCOUNTS_VIDEO'); ?>
                        <p>The tutorial video is still valid for using Google Photos Picker during the upload to local folders and AWS S3 buckets. The only difference is, that you need to add the libraty <b>Google Photos Picker API</b> instead of the Photos Library API.</p>
                    </p>
                    <?php if (!EVENTGALLERY_EXTENDED): ?>
                        <p>
                            <?php echo Text::_('COM_EVENTGALLERY_GOOGLEPHOTOS_LIMITATIONS_HINT'); ?>
                        </p>
                    <?php ENDIF ?>
                </div>
            </div>
            <p></p>

        <table class="table">
                <thead>
                    <tr>
                        <th width="20">
                            <input type="checkbox" name="checkall-toggle" value="" title="<?php echo Text::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
                        </th>
                        <th class="nowrap" width="1%">

                        </th>
                        <th>
                            <?php echo Text::_( 'COM_EVENTGALLERY_GOOGLEPHOTOSACCOUNT_NAME' ); ?>
                        </th>
                        <th>
                            <?php echo Text::_( 'COM_EVENTGALLERY_GOOGLEPHOTOSACCOUNT_CLIENTID' ); ?>
                        </th>
                        <th>
                            <?php echo Text::_( 'COM_EVENTGALLERY_GOOGLEPHOTOSACCOUNT_COMPLETED' ); ?>
                        </th>
                    </tr>
                </thead>


                <tbody>
                <?php $n=count($this->items); foreach ($this->items as $i => $item) :
                /**
                 * @var GooglePhotosAccount $item;
                 */
                ?>

                    <tr class="row<?php echo $i % 2; ?>">
                        <td class="center">
                            <?php echo \Joomla\CMS\HTML\HTMLHelper::_('grid.id', $i, $item->getId()); ?>
                        </td>
                        <td>
                            <div class="btn-group">
                                <a title="<?php echo Text::_('COM_EVENTGALLERY_BUTTON_EDIT_DESC'); ?>" class="btn btn-micro" href="<?php echo
                                     Route::_('index.php?option=com_eventgallery&task=googlephotosaccount.edit&id='.$item->getId()); ?>">
                                <i class="icon-edit"></i></a>
                            </div>
                        </td>
                        <td>
                                <?php echo $this->escape($item->getName()) ?><br>
                                <small><?php echo $this->escape($item->getDescription()) ?></small>

                        </td>
                        <td>
                            <?php echo $this->escape($item->getClientId()) ?>
                        </td>
                        <td>

                            <?php echo Text::_($this->escape($item->isUsable())?"JYES":"JNO") ?>,
                            <span class="account_validity" data-id="<?php echo $item->getId(); ?>"><?php Text::_('COM_EVENTGALLERY_GOOGLEPHOTOSACCOUNT_VALIDITY_LOADING')?></span>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
            <div class="pagination pagination-toolbar">
                <?php echo $this->pagination->getPagesLinks(); ?>
            </div>

    </div>

    <?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
    <input type="hidden" name="task" value="" />
    <input type="hidden" name="boxchecked" value="0" />
    <input type="hidden" name="limitstart" value="<?php echo $this->pagination->limitstart; ?>" />


</form>

<script>
    (function() {
        let labelValid = '<?php echo Text::_('COM_EVENTGALLERY_GOOGLEPHOTOSACCOUNT_VALIDITY_VALID')?>';
        let labelInvalid = '<?php echo Text::_('COM_EVENTGALLERY_GOOGLEPHOTOSACCOUNT_VALIDITY_INVALID')?>';
        let elements = document.getElementsByClassName("account_validity");
        for (let i = 0; i < elements.length; i++) {
            let element = elements[i];
            let id = element.dataset.id;
            let url = '<?php  echo  Route::_('index.php?option=com_eventgallery&task=googlephotos.testRefreshToken', false);?>&accountid=' + id;

            fetch(url)
                .then(response => response.json())
                .then(data => {
                    if (data.valid) {
                        element.innerHTML = labelValid;
                    } else {
                        element.innerHTML = '<b>' + labelInvalid + '</b>';

                    }
                    console.log('ddd', i);

                });

        }
    })();



</script>
