<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FileFactory;

defined('_JEXEC') or die('Restricted access');


/**
 * @var FileFactory $fileFactory
 */
$fileFactory = FileFactory::getInstance();
?>



<form action="<?php echo  Route::_('index.php?option=com_eventgallery&view=messages'); ?>"
      method="post" name="adminForm" id="adminForm">


    <div id="j-main-container">
        <div id="filter-bar" class="btn-toolbar eg-filter-bar">
            <div class="btn-group pull-right hidden-phone">
                <label for="limit" class="element-invisible"><?php echo Text::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC');?></label>
                <?php echo $this->pagination->getLimitBox(); ?>
            </div>
        </div>

        <p><?php echo Text::_('COM_EVENTGALLERY_MESSAGES_DESCRIPTION'); ?></p>

        <div class="clearfix"> </div>

        <table class="table">
            <thead>
                <tr>
                    <th width="20">
                        <input type="checkbox" name="checkall-toggle" value="" title="<?php echo Text::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
                    </th>
                    <th>

                    </th>
                    <th>

                    </th>

                </tr>
            </thead>
            <tbody>
            <?php foreach ($this->items as $i => $item) :
                $file = null;
                try {
                    $file = $fileFactory->getFile($item->folder, $item->file);
                } catch (\Exception $e) {

                }
            ?>

                <tr class="row<?php echo $i % 2; ?>">
                    <td class="center">
                        <?php echo \Joomla\CMS\HTML\HTMLHelper::_('grid.id', $i, $item->id); ?>
                    </td>

                    <td>
                        <?php IF ($file != null): ?>
                            <a href="<?php echo  Route::_('index.php?option=com_eventgallery&view=file&id=' . $file->getId())?>">
                            <?php echo $file->getThumbImgTag(150, 150, 'eventgallery-image', false, null, false, false); ?>
                            </a>
                        <?php ENDIF;?>

                    </td>
                    <td>
                        <small><?php echo $this->escape($item->created) ?></small><br />
                        <small><?php echo $this->escape($item->email) ?></small><br />
                        <?php echo $this->escape($item->message) ?>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
        <div class="pagination pagination-toolbar">
            <?php echo $this->pagination->getPagesLinks(); ?>
        </div>
    </div>

    <?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
    <input type="hidden" name="task" value="" />
    <input type="hidden" name="boxchecked" value="0" />
    <input type="hidden" name="limitstart" value="<?php echo $this->pagination->limitstart; ?>" />

</form>
