<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die('Restricted access');

/**
 * @var $item \Svenbluege\Component\Eventgallery\Site\Library\Order
 */
$item = $this->item;

?>

<div class="card">
    <h2 class="card-header"><?php echo Text::_('COM_EVENTGALLERY_ORDER_STATUS')?></h2>

    <div class="card-body">

        <form action="<?php echo Route::_('index.php?option=com_eventgallery&layout=edit&id='.$item->getId()); ?>" method="POST" name="adminForm" id="adminForm">

                    <div class="span12 row">
                        <p>
                        <?php echo Text::sprintf('COM_EVENTGALLERY_DATABASE_VERSION_LABEL' , $this->form->getField('version')->value, $item->getVersion())?>;
                        </p>
                        <fieldset class="adminform form-horizontal">

                            <?php foreach ($this->form->getFieldset() as $field): ?>
                                <div class="control-group">
                                    <?php if (!$field->hidden): ?>
                                        <div class="control-label"><?php echo $field->label; ?></div>
                                    <?php endif; ?>
                                    <div class="controls">
                                        <?php echo $field->input; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>

                        </fieldset>
                        <hr>
                    </div>
                <h3><?php echo Text::_('COM_EVENTGALLERY_ORDER_DATA')?></h3>
                    <div class="span12 row">
                        <div class="span4 col-4">
                            <h3><?php echo Text::_('COM_EVENTGALLERY_ORDER_GENERAL_INFORMATION')?></h3>
                            <?php $this->lineitemcontainer = $item; echo $this->loadTemplate('basicinformation');?>
                            <p>
                                <strong><?php echo Text::_('COM_EVENTGALLERY_ORDER_CREATIONDATE'); ?></strong>
                                <?php echo $item->getCreationDate(); ?><br>

                                <strong><?php echo Text::_('COM_EVENTGALLERY_ORDER_MODIFICATIONDATE'); ?></strong>
                                <?php echo $item->getModificationDate(); ?><br>

                                <strong><?php echo Text::_("COM_EVENTGALLERY_ORDERS_NEWSLETTER_OPTIN") ?>:</strong>
                                <?php echo $item->isNewsletterOptIn() ? Text::_("JYES") : Text::_("JNO"); ?>
                            </p>
                        </div>
                        <?php IF($item->getBillingAddress() != null):?>
                        <div class="span4 col-4">
                            <h3><?php echo Text::_('COM_EVENTGALLERY_ORDER_ADDRESS_BILLING')?></h3>
                            <div class="billingaddress">
                                <?php $this->address = $item->getBillingAddress(); echo $this->loadTemplate('address');?>
                            </div>
                        </div>
                        <?php ENDIF ?>
                        <?php IF($item->getShippingAddress() != null):?>
                        <div class="span4 col-4">
                            <h3><?php echo Text::_('COM_EVENTGALLERY_ORDER_ADDRESS_SHIPPING')?></h3>
                            <div class="shippingaddress">
                                <?php $this->address = $item->getShippingAddress(); echo $this->loadTemplate('address');?>
                            </div>
                        </div>
                        <?php ENDIF ?>

                    </div>
                    <div class="span12">
                        <hr>
                        <?php $this->lineitemcontainer = $item; echo $this->loadTemplate('summary');?>
                        <hr>
                        <?php $this->lineitemcontainer = $item; echo $this->loadTemplate('total');?>
                        <hr>
                    </div>


                    <?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
                    <input type="hidden" name="option" value="com_eventgallery" />
                    <input type="hidden" name="id" value="<?php echo $item->getId(); ?>" />
                    <input type="hidden" name="task" value="" />


                <h3><?php echo Text::_('COM_EVENTGALLERY_ORDER_RAW_DATA')?></h3>
                <pre class="span12">
                    <?php echo $this->loadTemplate('rawoutput'); ?>
                </pre>

                <h3><?php echo Text::_('COM_EVENTGALLERY_ORDER_SERVICELINEITEM_RAW_DATA')?></h3>
                <div class="span12">
                    <?php echo $this->loadTemplate('servicelineitemdata'); ?>
                </div>

        </form>
    </div>
</div>
