<?php 

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Svenbluege\Component\Eventgallery\Site\Library\Common\GeoObjects;

defined('_JEXEC') or die('Restricted access');

/**
* PARAMS:
* - address
*/
?>

<?php IF (!empty($this->address->getCompanyName())):?>
    <?php echo $this->escape($this->address->getCompanyName()); ?><br/>
<?php ENDIF; ?>
<?php echo $this->escape($this->address->getFirstName()); ?> <?php echo $this->escape($this->address->getLastName()); ?> <br/>
<?php echo $this->escape($this->address->getAddress1()); ?><br/>
<?php IF (!empty($this->address->getAddress2())):?>
    <?php echo $this->escape($this->address->getAddress2()); ?><br/>
<?php ENDIF; ?>
<?php IF (!empty($this->address->getAddress3())):?>
    <?php echo $this->escape($this->address->getAddress3()); ?><br/>
<?php ENDIF; ?>
<?php echo $this->escape($this->address->getZip()); ?> <?php echo $this->escape($this->address->getCity()); ?>
<?php IF (!empty($this->address->getState())):?>
    <br/><?php echo $this->escape(GeoObjects::getStateName($this->address->getState())); ?>
<?php ENDIF; ?>
<?php IF (!empty($this->address->getCountry())):?>
    <br/><?php echo $this->escape(GeoObjects::getCountryName($this->address->getCountry())); ?>
<?php ENDIF; ?>
