<?php 

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Svenbluege\Component\Eventgallery\Site\Library\ImageLineitem;

defined('_JEXEC') or die('Restricted access');

?>

<div class="cart-items">

        <?php foreach ($this->lineitemcontainer->getLineItems() as $lineitem) :
            /** @var ImageLineitem $lineitem */
             ?>

                <div class="row-fluid row">
                    <div class="span2 col-2 image">
                        <?php echo $lineitem->getCartThumb(); ?>
                    </div>

                    <span class="span1 col-1 price">
                        <?php echo $lineitem->getPrice(); ?>
                    </span>

                    <div class="span9 col-9 information">
                        <span class="folder"><?php echo $this->escape($lineitem->getFolderName()); ?></span>
                        <span class="file"><?php echo $this->escape($lineitem->getFileName()); ?> <?php IF ($lineitem->getOriginalFilename() != $lineitem->getFileName() && !empty($lineitem->getOriginalFilename())):?>(<?php echo $lineitem->getOriginalFilename()?>)<?php ENDIF?></span>
                        <span class="quantity"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDER_QUANTITY') ?>: <?php echo $lineitem->getQuantity() ?></span>
                        <?php IF (!empty($lineitem->getBuyerNote())): ?>
                        <p class="buyernote"><blockquote><?php echo nl2br($this->escape($lineitem->getBuyerNote())); ?></blockquote></p>
                        <?php ENDIF; ?>
                        <p class="imagetype-details">
                            <?php IF ($lineitem->getImageType()): ?>
                                <span class="displayname"><?php echo $lineitem->getImageType()->getDisplayName() ?></span>
                                <span class="description"><?php echo $lineitem->getImageType()->getDescription() ?></span>
                                <span class="singleprice"><?php echo \Joomla\CMS\Language\Text::sprintf('COM_EVENTGALLERY_ORDER_PRICE_PER_ITEM_WITH_PLACEHOLDER', $lineitem->getImageType()->getPrice()) ?></span>
                            <?php ENDIF ?>
                        </p>
                    </div>
                </div>

        <?php endforeach ?>
</div>
