<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\Order;

defined('_JEXEC') or die('Restricted access');

\Joomla\CMS\HTML\HTMLHelper::addIncludePath(JPATH_COMPONENT . '/helpers/html');

/**
 * @var Order $order
 */
$order = $this->item;


?>

<style>
    #modalordereditform legend {
        display: none;
    }

    #modalordereditform fieldset>div:nth-of-type(1) {
        display: none;
    }

    #modalordereditform fieldset>hr:nth-of-type(1) {
        display: none;
    }

</style>

<?php

echo $this->renderMessages();

?>
<div data-action="<?php echo Route::_('index.php?format=raw&option=com_eventgallery&layout=edit&id='. $order->getId()); ?>" method="POST" name="modalordereditform" id="modalordereditform">

    <div class="btn-group">
        <input type="submit"
               class="saveInlineForm btn btn-success"
               data-task="order.apply"
               data-id="<?php echo $order->getId(); ?>"
               value="<?php echo \Joomla\CMS\Language\Text::_('JTOOLBAR_APPLY'); ?>">
        <input type="submit"
               class="saveInlineForm btn"
               data-task="order.save"
               data-id="<?php echo $order->getId(); ?>"
               value="<?php echo \Joomla\CMS\Language\Text::_('JTOOLBAR_SAVE'); ?>">
        <input type="submit"
               class="closeInlineForm btn"
               data-id="<?php echo $order->getId(); ?>"
               data-href="<?php echo  Route::_('index.php?option=com_eventgallery&view=order&layout=content&tmpl=component&format=raw&id='. $order->getId()); ?>"
               value="<?php echo \Joomla\CMS\Language\Text::_('JTOOLBAR_CLOSE'); ?>">
    </div>
    <input type="hidden" name="tmpl" value="component">


    <div id="j-main-container">
        <?php echo $this->loadSnippet('formfields_without_tabs'); ?>
    </div>

    <?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
    <input type="hidden" name="option" value="com_eventgallery" />
    <input type="hidden" name="id" value="<?php echo $this->item->getId(); ?>" />
    <input type="hidden" name="task" value="order.apply" />
</div>
