<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\HTML\Helpers\Sidebar;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\Order;

defined('_JEXEC') or die('Restricted access');


$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
$sortFields = $this->getSortFields();
?>

<script type="text/javascript">
    document.addEventListener("DOMContentLoaded", function() {
        Joomla.orderTable = function () {
            table = document.getElementById("sortTable");
            direction = document.getElementById("directionTable");
            order = table.options[table.selectedIndex].value;
            if (order != '<?php echo $listOrder; ?>') {
                dirn = 'asc';
            } else {
                dirn = direction.options[direction.selectedIndex].value;
            }
            Joomla.tableOrdering(order, dirn, '');
        }
    });
</script>

<form action="<?php echo Route::_('index.php?option=com_eventgallery&view=orders'); ?>"
      method="post" name="adminForm" id="adminForm">

    <div id="j-main-container">
            <div class="btn-toolbar eg-filter-bar input-group">
                <?php foreach (Sidebar::getFilters() as $filter) : ?>
                    <div class="btn-group">
                        <select name="<?php echo $filter['name']; ?>" id="<?php echo $filter['name']; ?>" class="custom-select" onchange="this.form.submit()">
                            <?php if (!$filter['noDefault']) : ?>
                                <option value=""><?php echo $filter['label']; ?></option>
                            <?php endif; ?>
                            <?php echo $filter['options']; ?>
                        </select>
                    </div>
                <?php endforeach; ?>

                <div class="input-group">
                    <input class="form-control" type="text" name="filter_search" id="filter_search" placeholder="<?php echo Text::_('COM_EVENTGALLERY_ORDERS_SEARCH_PLACEHOLDER'); ?>" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" title="<?php echo Text::_('COM_EVENTGALLERY_ORDERS_SEARCH_DESC'); ?>" />
                    <button class="btn hasTooltip" type="submit" title="<?php echo Text::_('JSEARCH_FILTER_SUBMIT'); ?>"><i class="icon-search"></i></button>
                    <button class="btn hasTooltip" type="button" title="<?php echo Text::_('JSEARCH_FILTER_CLEAR'); ?>" onclick="document.getElementById('filter_search').value='';this.form.submit();"><i class="icon-remove"></i></button>
                </div>
                <div class="btn-group hidden-phone">
                    <label for="limit" class="element-invisible"><?php echo Text::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC');?></label>
                    <?php echo $this->pagination->getLimitBox(); ?>
                </div>
                <div class="btn-group hidden-phone">
                    <label for="directionTable" class="element-invisible"><?php echo Text::_('JFIELD_ORDERING_DESC');?></label>
                    <select name="directionTable" id="directionTable" class="form-select input-medium" onchange="Joomla.orderTable()">
                        <option value=""><?php echo Text::_('JFIELD_ORDERING_DESC');?></option>
                        <option value="asc" <?php if ($listDirn == 'asc') echo 'selected="selected"'; ?>><?php echo Text::_('COM_EVENTGALLERY_ORDER_ASCENDING');?></option>
                        <option value="desc" <?php if ($listDirn == 'desc') echo 'selected="selected"'; ?>><?php echo Text::_('COM_EVENTGALLERY_ORDER_DESCENDING');?></option>
                    </select>
                </div>
                <div class="btn-group">
                    <label for="sortTable" class="element-invisible"><?php echo Text::_('COM_EVENTGALLERY_SORT_BY');?></label>
                    <select name="sortTable" id="sortTable" class="form-select input-medium" onchange="Joomla.orderTable()">
                        <option value=""><?php echo Text::_('COM_EVENTGALLERY_SORT_BY');?></option>
                        <?php echo \Joomla\CMS\HTML\HTMLHelper::_('select.options', $sortFields, 'value', 'text', $listOrder);?>
                    </select>
                </div>
            </div>
            <div class="clearfix"> </div>
        <table class="table">
            <thead>
            <tr>
                <th width="20">
                    <input type="checkbox" name="checkall-toggle" value="" title="<?php echo Text::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
                </th>
                <th class="nowrap" width="1%">

                </th>
                <th class="nowrap" width="1%">

                </th>
                <th>
                    <?php echo Text::_( 'COM_EVENTGALLERY_ORDERS_STATUS' ); ?>
                </th>
                <th>
                    <?php echo Text::_( 'COM_EVENTGALLERY_ORDERS_DETAILS' ); ?>
                </th>

                <th>
                    <?php echo Text::_( 'COM_EVENTGALLERY_ORDERS_PRICING' ); ?>
                </th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($this->items as $i => $item) :
            /**
             * @var Order $item;
             */

                $editLink = Route::_('index.php?option=com_eventgallery&view=order&layout=edit&id='.$item->getId());
                $editLinkAjax = $editLink . '&tmpl=component&format=raw';
                $this->item = $item;

                $user = $this->item->getUser();
                ?>

                <tr class="row<?php echo $i % 2; ?>">
                    <td class="center">
                        <?php echo \Joomla\CMS\HTML\HTMLHelper::_('grid.id', $i, $item->getId()); ?>
                    </td>
                    <td>
                        <div class="btn-group">

                            <a title="<?php echo Text::_('COM_EVENTGALLERY_BUTTON_EDIT_DESC'); ?>" class="btn btn-micro" href="<?php echo
                            Route::_('index.php?option=com_eventgallery&task=order.edit&id='.$item->getId()); ?>">
                                <i class="icon-edit"></i></a>

                        </div>
                    </td>
                    <td>
                        <?php echo $this->escape($item->getDocumentNumber()); ?>
                    </td>
                    <td>
                        <div data-id="<?php echo $this->item->getId(); ?>" data-editlink="<?php echo $editLinkAjax; ?>">
                            <?php echo $this->loadTemplate('orderstatus'); ?>
                        </div>
                    </td>
                    <td>

                        <?php echo Text::sprintf('COM_EVENTGALLERY_ORDERS_COUNT_SUMMARY', $item->getLineItemsCount(), $item->getLineItemsTotalCount()); ?>

                        <p class="smallsub">
                            <small>
                                <?php IF ($user != null && $user->email != null):?>
                                    <b><?php echo Text::_("COM_EVENTGALLERY_ORDERS_USER"); ?></b><br>
                                    <a href="<?php echo Route::_("index.php?option=com_users&task=user.edit&id=") . $user->id?>"><?php echo Text::_("COM_EVENTGALLERY_ORDERS_USER_MANAGE"); ?></a>
                                    <a href="mailto:<?php echo $this->escape($user->email) ?>"><?php echo $this->escape($user->username . ' (' . $user->email . ')') ?></a><br><br>
                                <?php ENDIF ?>
                                <?php IF (!empty($item->getEMail())):?>
                                    <a href="mailto:<?php echo $this->escape($item->getEMail()) ?>"><?php echo $this->escape($item->getEMail()) ?></a><br>
                                <?php ENDIF ?>

                                <?php IF (!empty($item->getPhone())):?>
                                    <a href="tel:<?php echo $this->escape($item->getPhone()) ?>"><?php echo $this->escape($item->getPhone()) ?></a><br>
                                <?php ENDIF ?>
                                <?php IF ($item->getBillingAddress()): ?>
                                    <?php echo $this->escape($item->getBillingAddress()->getFirstName()) ?>
                                    <?php echo $this->escape($item->getBillingAddress()->getLastName()) ?><br>
                                <?php ELSE: ?>
                                    <?php echo $this->escape($item->getFirstName()) ?>
                                    <?php echo $this->escape($item->getLastName()) ?><br>
                                <?php ENDIF ?>
                                <?php echo Text::_("COM_EVENTGALLERY_ORDERS_NEWSLETTER_OPTIN") ?>:
                                <?php echo $item->isNewsletterOptIn() ? Text::_("JYES") : Text::_("JNO"); ?>
                            </small>

                        </p>
                    </td>
                    <td>

                        <small>
                        <dl class="dl-horizontal" style="margin:0">
                            <dt><?php echo Text::_( 'COM_EVENTGALLERY_ORDERS_TOTAL' ); ?></dt>
                            <dd>
                               <strong> <?php echo $item->getTotal() ?></strong>
                            <dd>
                            <dt><?php echo Text::_( 'COM_EVENTGALLERY_ORDERS_SUBTOTAL' ); ?></dt>
                            <dd>
                                <?php echo $item->getSubTotal() ?>
                            </dd>

                            <dt><?php echo Text::_( 'COM_EVENTGALLERY_ORDERS_SURCHARGE' ); ?> </dt>
                            <dd>
                                <?php IF ($item->getSurchargeServiceLineItem()): ?>
                                    <?php echo $item->getSurchargeServiceLineItem()->getPrice() ?>
                                <?php ELSE: ?>
                                    -
                                <?php ENDIF ?>
                            </dd>

                            <dt><?php echo Text::_( 'COM_EVENTGALLERY_ORDERS_PAYMENT' ); ?> </dt>
                            <dd>
                                <?php IF ($item->getPaymentMethodServiceLineItem()): ?>
                                  <?php echo $item->getPaymentMethodServiceLineItem()->getPrice() ?>
                                <?php ELSE: ?>
                                    -
                                <?php ENDIF ?>
                            </dd>

                            <dt><?php echo Text::_( 'COM_EVENTGALLERY_ORDERS_SHIPPING' ); ?>  </dt>
                            <dd>
                                <?php IF ($item->getShippingMethodServiceLineItem()): ?>
                                    <?php echo $item->getShippingMethodServiceLineItem()->getPrice() ?>
                                <?php ELSE: ?>
                                    -
                                <?php ENDIF ?>
                            </dd>
                        </dl>
                        </small>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
        <div class="pagination pagination-toolbar">
            <?php echo $this->pagination->getPagesLinks(); ?>
        </div>
    </div>

    <?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
    <input type="hidden" name="task" value="" />
    <input type="hidden" name="boxchecked" value="0" />
    <input type="hidden" name="limitstart" value="<?php echo $this->pagination->limitstart; ?>" />
    <input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
    <input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />

</form>
