<?php 

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

/**
 * @var \Svenbluege\Component\Eventgallery\Site\Library\Order $item
 */
$item = $this->item;

?>

<div class="openInlineForm">

    <?php IF ($item->getOrderStatus()): ?>
        <div class="eg-orderstatus orderStatus" style="background-color: <?php echo $item->getOrderStatus()->getHightlightColor()?>">
            <?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDERSTATUS_TYPE_ORDER'); ?>:
            <strong class="order<?php echo $item->getOrderStatus()->getId() ?>"><?php echo $item->getOrderStatus()->getDisplayName() ?></strong>
        </div>
    <?php ENDIF ?>

    <?php IF ($item->getPaymentStatus()): ?>
        <div class="eg-orderstatus paymentStatus" style="background-color: <?php echo $item->getPaymentStatus()->getHightlightColor()?>">
            <?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDERSTATUS_TYPE_PAYMENT'); ?>:
            <strong class="payment<?php echo $item->getPaymentStatus()->getId()?>"><?php echo $item->getPaymentStatus()->getDisplayName() ?></strong>
        </div>
    <?php ENDIF ?>

    <?php IF ($item->getShippingStatus()): ?>
        <div class="eg-orderstatus shippingStatus" style="background-color: <?php echo $item->getShippingStatus()->getHightlightColor()?>">
            <?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDERSTATUS_TYPE_SHIPPING'); ?>:
            <strong class="shipping<?php echo $item->getShippingStatus()->getId()?>" ><?php echo $item->getShippingStatus()->getDisplayName() ?></strong>
        </div>
    <?php ENDIF ?>

    <small><?php echo $item->getCreationDate(); ?></small>
</div>

