<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\OrderStatus;

defined('_JEXEC') or die('Restricted access');


?>

<form action="<?php echo  Route::_('index.php?option=com_eventgallery&view=orderstatuses'); ?>"
      method="post" name="adminForm" id="adminForm">

    <div id="j-main-container">
        <div id="filter-bar" class="btn-toolbar eg-filter-bar">
            <div class="btn-group pull-right hidden-phone">
                <label for="limit" class="element-invisible"><?php echo Text::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC');?></label>
                <?php echo $this->pagination->getLimitBox(); ?>
            </div>
        </div>
        <div class="clearfix"> </div>

        <table class="table">
            <thead>
                <tr>
                    <th width="20">
                        <input type="checkbox" name="checkall-toggle" value="" title="<?php echo Text::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
                    </th>
                    <th class="nowrap" width="1%">
                        <?php echo Text::_( 'COM_EVENTGALLERY_ORDERSTATUS_TYPE' ); ?>
                    </th>
                    <th class="nowrap" width="1%">

                    </th>
                     <th width="1%">
                        <?php echo Text::_( 'COM_EVENTGALLERY_EVENTS_ORDER' ); ?>
                        <?php echo (new \Joomla\CMS\Layout\FileLayout('eventgallery.orderingsave'))->render(['task'=>'orderstatuses.saveorder']); ?>
                    </th>
                    <th>
                        <?php echo Text::_( 'COM_EVENTGALLERY_ORDERSTATUSES_DETAIS' ); ?>
                    </th>


                </tr>
            </thead>


            <tbody>
            <?php $n=count($this->items); foreach ($this->items as $i => $item) :
            /**
             * @var OrderStatus $item;
             */
            ?>

                <tr class="row<?php echo $i % 2; ?>">
                    <td class="center">
                        <?php echo \Joomla\CMS\HTML\HTMLHelper::_('grid.id', $i, $item->getId()); ?>
                    </td>
                    <td>
                        <?php IF ($item->getType()==OrderStatus::TYPE_ORDER) echo Text::_('COM_EVENTGALLERY_ORDERSTATUS_TYPE_ORDER'); ?>
                        <?php IF ($item->getType()==OrderStatus::TYPE_SHIPPING) echo Text::_('COM_EVENTGALLERY_ORDERSTATUS_TYPE_SHIPPING'); ?>
                        <?php IF ($item->getType()==OrderStatus::TYPE_PAYMENT) echo Text::_('COM_EVENTGALLERY_ORDERSTATUS_TYPE_PAYMENT'); ?>

                    </td>
                    <td>
                        <div class="btn-group">
                            <?php IF ($item->isDefault()): ?>
                                <a title="<?php echo Text::_('COM_EVENTGALLERY_BUTTON_ISDEFAULT_DESC'); ?>" href="#" class="btn btn-micro active"><i class="icon-star"></i></a>
                            <?php ELSE:?>
                                <a title="<?php echo Text::_('COM_EVENTGALLERY_BUTTON_NOTDEFAULT_DESC'); ?>" href="#" onclick="return Joomla.listItemTask('cb<?php echo $i; ?>','orderstatuses.default')" class="btn btn-micro"><i class="icon-star-empty"></i></a>
                            <?php ENDIF ?>
                            <a title="<?php echo Text::_('COM_EVENTGALLERY_BUTTON_EDIT_DESC'); ?>" class="btn btn-micro" href="<?php echo
                                 Route::_('index.php?option=com_eventgallery&task=orderstatus.edit&id='.$item->getId()); ?>">
                            <i class="icon-edit"></i></a>
                        </div>
                    </td>
                    <td class="order nowrap">
                        <?php echo (new \Joomla\CMS\Layout\FileLayout('eventgallery.orderingcontrolls'))->render(['currentIndex' => $i, 'numberOfItems'=>$n, 'value'=>$item->getOrdering(), 'pagination'=>$this->pagination, 'taskPrefix'=>'orderstatuses']); ?>
                    </td>
                    <td>
                        <?php echo $this->escape($item->getDisplayName()) ?>
                        <?php IF ($item->isSystemManaged()): ?>
                            <i title="<?php echo Text::_('COM_EVENTGALLERY_ORDERSTATUS_SYSTEMMANAGED') ?>" class="icon-locked"></i>
                        <?php ENDIF ?>
                        <br>
                        <small><?php echo $this->escape($item->getDescription()) ?></small><br>
                    </td>

                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
        <div class="pagination pagination-toolbar">
            <?php echo $this->pagination->getPagesLinks(); ?>
        </div>
    </div>

    <?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
    <input type="hidden" name="task" value="" />
    <input type="hidden" name="boxchecked" value="0" />
    <input type="hidden" name="limitstart" value="<?php echo $this->pagination->limitstart; ?>" />

</form>
