<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\HTML\HTMLHelper;

if (!isset($noTabSet)) {
    $noTabSet = false;
}

function getLabel($field) {

    $tipTitle = \Joomla\CMS\Language\Text::_($field->description);
    $title = $field->title;

    $toolTipTitle = HTMLHelper::_('tooltipText', $title ?: $title, '', 0);
    $toolTipContent = HTMLHelper::_('tooltipText', $tipTitle ?: $title, '', 0);

    // TODO: remove this. This is a workaround because the calendar-field is doing something in the input-method, but not in the label-method.
    $dummy = $field->input;

    $labelContent = <<<CONTENT
      <div class="control-label "
           title="$toolTipTitle"
           data-content="$toolTipContent"
           data-placement="top"
      >
      {$field->label}
      </div>
CONTENT;
    return $labelContent;
}

function addTab($name, $label, $noTabSet) {
    if ($noTabSet) return "";
    return HTMLHelper::_('uitab.addTab', 'myTab', $name, $label);
}

function endTab($noTabSet) {
    if ($noTabSet) return "";
    return HTMLHelper::_('uitab.endTab');
}

function startTabSet($defaultTabName, $noTabSet) {
    if ($noTabSet) return "";
    return HTMLHelper::_('uitab.startTabSet', 'myTab', array('active' => $defaultTabName));
}

function endTabSet($noTabSet) {
    if ($noTabSet) return "";
    return HTMLHelper::_('uitab.endTabSet');
}

?>

<div class="adminform form-horizontal">
    <fieldset>
            <?php echo startTabSet('general', $noTabSet)?>
            <?php foreach($this->form->getFieldsets() as $fieldset): ?>
                <?php echo addTab($fieldset->name, \Joomla\CMS\Language\Text::_($fieldset->label, true), $noTabSet); ?>
                <?php IF (!empty(\Joomla\CMS\Language\Text::_($fieldset->description))): ?>
                    <div><?php echo \Joomla\CMS\Language\Text::_($fieldset->description); ?></div>
                    <hr>
                <?php ENDIF ?>
                <?php foreach ($this->form->getFieldset($fieldset->name) as $field): ?>
                    <?php IF($field->type == 'formfieldgroup') { echo $field->getInput(); continue;} ?>
                    <?php $dataShowOn = ''; ?>
                    <?php if ($field->showon) : ?>
                        <?php \Joomla\CMS\HTML\HTMLHelper::_('script', 'jui/cms.js', array('version' => 'auto', 'relative' => true)); ?>
                        <?php $dataShowOn = ' data-showon=\'' . json_encode(\Joomla\CMS\Form\FormHelper::parseShowOnConditions($field->showon, $field->formControl, $field->group)) . '\''; ?>
                    <?php endif; ?>
                    <div class="control-group" <?php echo $dataShowOn; ?> style="<?php if ($field->hidden) echo "display:none" ?>">
                        <?php if (!$field->hidden):?>
                        <div class="control-label"><?php echo getLabel($field) ?></div>
                        <?php endif; ?>
                        <div class="controls">
                            <?php echo $field->input; ?>
                            <?php if (!$field->hidden && !empty(\Joomla\CMS\Language\Text::_($field->description))) : ?>
                                <div id="<?php echo isset($id)?$id:''; ?>">
                                    <small class="form-text text-muted">
                                        <?php echo \Joomla\CMS\Language\Text::_($field->description); ?>
                                    </small>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
                <?php echo endTab($noTabSet); ?>
            <?php endforeach ?>
            <?php echo endTabSet($noTabSet); ?>

    </fieldset>
</div>
