<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;

defined('_JEXEC') or die('Restricted access');
/**
 *  @var \de\svenbluege\joomla\eventgallery\ObjectWithConfiguration $this
 */

$isFinderFilePluginEnabled = \Joomla\CMS\Plugin\PluginHelper::isEnabled('finder', 'eventgallery_file');


?>

<div class="card">
    <div class="card-body">
        <?php IF($isFinderFilePluginEnabled):?>
            <div class="alert alert-primary">
                <?php echo Text::sprintf('COM_EVENTGALLERY_FINDER_FILE_PLUGING_WARNING');?>
            </div>
        <?php ENDIF; ?>
        <p class="well">
            <?php echo Text::_('COM_EVENTGALLERY_SYNC_START2_DESC'); ?>
        </p>
    </div>
</div>
<br>
<div class="card">
    <div class="card-body">
        <div id="filesync"
             data-csrf-token="<?php echo Session::getFormToken()?>"
             data-load-folders-url="<?php echo Route::_('index.php?option=com_eventgallery&format=raw&task=sync.init', false);?>"
             data-file-sync-url="<?php echo Route::_('index.php?option=com_eventgallery&format=raw&task=sync.processFiles', false);?>"
             data-folder-sync-url="<?php echo Route::_('index.php?option=com_eventgallery&format=raw&task=sync.processFolder', false);?>"
             data-file-batch-size="<?php echo $this->config->getStorage()->getMaxItemsPerBatch() ?>"
             data-max-parallel-requests="<?php echo $this->config->getStorage()->getMaxParallelRequests() ?>"
             data-i18n-COM_EVENTGALLERY_SYNC_OPEN_IMAGES_NEEDS_SYNC="<?php echo Text::_( 'COM_EVENTGALLERY_SYNC_OPEN_IMAGES_NEEDS_SYNC' ); ?>"
             data-i18n-COM_EVENTGALLERY_SYNC_CHECK_ALL="<?php echo Text::_( 'COM_EVENTGALLERY_SYNC_CHECK_ALL' ); ?>"
             data-i18n-COM_EVENTGALLERY_SYNC_CHECK_NONE="<?php echo Text::_( 'COM_EVENTGALLERY_SYNC_CHECK_NONE' ); ?>";
             data-i18n-COM_EVENTGALLERY_SYNC_STOP_QUEUE="<?php echo Text::_( 'COM_EVENTGALLERY_SYNC_STOP_QUEUE' ); ?>";
             data-i18n-COM_EVENTGALLERY_SYNC_ERROR_HEADLINE="<?php echo Text::_( 'COM_EVENTGALLERY_SYNC_ERROR_HEADLINE' ); ?>";
             data-i18n-COM_EVENTGALLERY_SYNC_STEP1="<?php echo Text::_( 'COM_EVENTGALLERY_SYNC_STEP1' ); ?>";
             data-i18n-COM_EVENTGALLERY_SYNC_STEP2="<?php echo Text::_( 'COM_EVENTGALLERY_SYNC_STEP2' ); ?>";
             data-i18n-COM_EVENTGALLERY_SYNC_STEP2_HINT="<?php echo Text::_( 'COM_EVENTGALLERY_SYNC_SELECT_AN_EVENT_HINT' ); ?>";
             data-i18n-COM_EVENTGALLERY_SYNC_STEP2_ITEMS="<?php echo Text::_( 'COM_EVENTGALLERY_SYNC_STEP2_ITEMS' ); ?>";
             data-i18n-COM_EVENTGALLERY_SYNC_STEP2_BUTTON_LABEL="<?php echo Text::_( 'COM_EVENTGALLERY_SYNC_FOLDERS' ); ?>";
             data-i18n-COM_EVENTGALLERY_SYNC_STEP3="<?php echo Text::_( 'COM_EVENTGALLERY_SYNC_STEP3' ); ?>";
             data-i18n-COM_EVENTGALLERY_SYNC_STEP3_HINT="<?php echo Text::_( 'COM_EVENTGALLERY_SYNC_FILE_SYNC_HINT_DESC' ); ?>";
             data-i18n-COM_EVENTGALLERY_SYNC_STEP3_BUTTON_LABEL="<?php echo Text::_( 'COM_EVENTGALLERY_SYNC_FILES' ); ?>";
             data-i18n-COM_EVENTGALLERY_SYNC_STEP3_ITEMS="<?php echo Text::_( 'COM_EVENTGALLERY_SYNC_STEP3_ITEMS' ); ?>";
        ></div>
    </div>
</div>



<form action="<?php echo Route::_('index.php'); ?>" method="post" name="adminForm" id="adminForm">
    <input type="hidden" name="option" value="com_eventgallery" />
    <input type="hidden" name="task" value="" />
    <?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
</form>
