<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main;

defined('_JEXEC') or die('Restricted access');
/**
 *  @var \de\svenbluege\joomla\eventgallery\ObjectWithConfiguration $this
 */


?>
<div class="card">
    <div class="card-body">
    <div id="thumbnailcreator"
         data-csrf-token="<?php echo Session::getFormToken()?>"
         data-i18n-COM_EVENTGALLERY_THUMBNAILGENERATOR_START2_DESC="<?php echo Text::_( 'COM_EVENTGALLERY_THUMBNAILGENERATOR_START2_DESC' ); ?>";
         data-i18n-COM_EVENTGALLERY_THUMBNAILGENERATOR_REFRESHETAGS_DESC="<?php echo Text::_( 'COM_EVENTGALLERY_THUMBNAILGENERATOR_REFRESHETAGS_DESC' ); ?>";
         data-load-folders-url="<?php echo Route::_('index.php?option=com_eventgallery&format=raw&task=thumbnailgenerator.init', false);?>"
         data-file-sync-url="<?php echo Route::_('index.php?option=com_eventgallery&format=raw&task=thumbnailgenerator.processfile', false);?>"
         data-folder-sync-url="<?php echo Route::_('index.php?option=com_eventgallery&format=raw&task=thumbnailgenerator.processfolder', false);?>"
         data-file-batch-size="<?php echo $this->config->getImage()->getMaxItemsPerBatch() ?>"
         data-max-parallel-requests="<?php echo $this->config->getImage()->getMaxParallelRequests() ?>"
         data-i18n-COM_EVENTGALLERY_SYNC_CHECK_ALL="<?php echo Text::_( 'COM_EVENTGALLERY_SYNC_CHECK_ALL' ); ?>"
         data-i18n-COM_EVENTGALLERY_SYNC_CHECK_NONE="<?php echo Text::_( 'COM_EVENTGALLERY_SYNC_CHECK_NONE' ); ?>";
         data-i18n-COM_EVENTGALLERY_SYNC_STOP_QUEUE="<?php echo Text::_( 'COM_EVENTGALLERY_SYNC_STOP_QUEUE' ); ?>";
         data-i18n-COM_EVENTGALLERY_SYNC_ERROR_HEADLINE="<?php echo Text::_( 'COM_EVENTGALLERY_SYNC_ERROR_HEADLINE' ); ?>";
         data-i18n-COM_EVENTGALLERY_SYNC_STEP1="<?php echo Text::_( 'COM_EVENTGALLERY_SYNC_STEP1' ); ?>";
         data-i18n-COM_EVENTGALLERY_SYNC_STEP2_HINT="<?php echo Text::_( 'COM_EVENTGALLERY_THUMBNAILGENERATOR_GETMISSINGTHUMBNAILS' ); ?>";
         data-i18n-COM_EVENTGALLERY_THUMBNAILGENERATOR_GETMISSINGTHUMBNAILS="<?php echo Text::_( 'COM_EVENTGALLERY_THUMBNAILGENERATOR_GETMISSINGTHUMBNAILS' ); ?>";
         data-i18n-COM_EVENTGALLERY_THUMBNAILGENERATOR_START="<?php echo Text::_( 'COM_EVENTGALLERY_THUMBNAILGENERATOR_START' ); ?>";
         data-i18n-COM_EVENTGALLERY_THUMBNAILGENERATOR_START_THUMBNAILCREATION="<?php echo Text::_( 'COM_EVENTGALLERY_THUMBNAILGENERATOR_START_THUMBNAILCREATION' ); ?>";
         data-i18n-COM_EVENTGALLERY_THUMBNAILGENERATOR_OPEN_IMAGES_NEEDS_SYNC="<?php echo Text::_( 'COM_EVENTGALLERY_THUMBNAILGENERATOR_OPEN_IMAGES_NEEDS_SYNC' ); ?>";
         data-i18n-COM_EVENTGALLERY_THUMBNAILGENERATOR_STEP2_ITEMS="<?php echo Text::_( 'COM_EVENTGALLERY_THUMBNAILGENERATOR_STEP2_ITEMS' ); ?>";
         data-i18n-COM_EVENTGALLERY_THUMBNAILGENERATOR_STEP3_ITEMS="<?php echo Text::_( 'COM_EVENTGALLERY_THUMBNAILGENERATOR_STEP3_ITEMS' ); ?>";
    ></div>
    </div>
</div>

<form action="<?php echo Route::_('index.php'); ?>" method="post" name="adminForm" id="adminForm">
    <input type="hidden" name="option" value="com_eventgallery" />
    <input type="hidden" name="task" value="" />
    <?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
</form>
