<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\Folder;

defined('_JEXEC') or die('Restricted access');

/**
 * @var Folder $folder
 */
$folder = $this->folder;

$safeFolderName = Joomla\Filesystem\Folder::makeSafe($folder->getFolderName());
$validFolderName = strcmp($folder->getFolderName(), $safeFolderName) == 0 ?  true : false;

// Returns a file size limit in bytes based on the PHP upload_max_filesize
// and post_max_size
function file_upload_max_size() {
    static $max_size = -1;

    if ($max_size < 0) {
        // Start with post_max_size.
        $post_max_size = parse_size(ini_get('post_max_size'));
        if ($post_max_size > 0) {
            $max_size = $post_max_size;
        }

        // If upload_max_size is less, then reduce. Except if upload_max_size is
        // zero, which indicates no limit.
        $upload_max = parse_size(ini_get('upload_max_filesize'));
        if ($upload_max > 0 && $upload_max < $max_size) {
            $max_size = $upload_max;
        }
    }
    return $max_size;
}

function parse_size($size) {
    $unit = preg_replace('/[^bkmgtpezy]/i', '', $size); // Remove the non-unit characters from the size.
    $size = preg_replace('/[^0-9\.]/', '', $size); // Remove the non-numeric characters from the size.
    if ($unit) {
        // Find the position of the unit in the ordered string which is the power of magnitude to multiply a kilobyte by.
        return round($size * pow(1024, stripos('bkmgtpezy', $unit[0])));
    }
    else {
        return round($size);
    }
}

if (!$folder->supportsFileUpload()) {
    echo Text::_('COM_EVENTGALLERY_EVENT_UPLOAD_NOT_SUPPORTED');
    return;
}
$config = \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main::getInstance();
$resizeSize = $config->getImage()->getResizeImageSize();
$i18nKeys = [
    'COM_EVENTGALLERY_EVENT_UPLOAD_FILES_TO_UPLOAD',
    'COM_EVENTGALLERY_EVENT_UPLOAD_PENDING',
    'COM_EVENTGALLERY_EVENT_UPLOAD_FINISHED',
    'COM_EVENTGALLERY_EVENT_UPLOAD_DO_RESIZE_LABEL',
    'COM_EVENTGALLERY_EVENT_UPLOAD_DO_DOWNLOAD_RESIZED_IMAGES_LABEL',
    'COM_EVENTGALLERY_EVENT_UPLOAD_NO_GOOGLE_ACCOUNTS',
    'COM_EVENTGALLERY_EVENT_UPLOAD_SELECT_GOOGLE_PHOTOS',
    'COM_EVENTGALLERY_EVENT_UPLOAD_SELECT_LOCAL_FILES',
    'COM_EVENTGALLERY_EVENT_UPLOAD_GOOGLE_PHOTOS_START_NEW_SELECTION',
    'COM_EVENTGALLERY_EVENT_UPLOAD_GOOGLE_PHOTOS_LOADING_SESSION',
    'COM_EVENTGALLERY_EVENT_UPLOAD_GOOGLE_PHOTOS_PICKER_HEADLINE',
    'COM_EVENTGALLERY_EVENT_UPLOAD_GOOGLE_PHOTOS_PICKER_SESSION_RUNTIME',
    'COM_EVENTGALLERY_EVENT_UPLOAD_GOOGLE_PHOTOS_PICKER_LINK_DESC',
    'COM_EVENTGALLERY_EVENT_UPLOAD_GOOGLE_PHOTOS_PICKER_RELOAD_DESC',
    'COM_EVENTGALLERY_EVENT_UPLOAD_GOOGLE_PHOTOS_PICKER_SELECTED_IMAGES_DESC',
    'COM_EVENTGALLERY_EVENT_UPLOAD_GOOGLE_PHOTOS_PICKER_UPLOAD_BUTTON_LABEL',
    'COM_EVENTGALLERY_EVENT_UPLOAD_MANAGE_GOOGLE_ACCOUNTS',
];
$i18n = [];
foreach ($i18nKeys as $key) {
    $i18n[$key] = Text::_($key);
}

?>

    <?php IF (!$validFolderName): ?>
        <div class="card mb-3">
            <div class="card-body">
                <?php echo Text::sprintf('COM_EVENTGALLERY_SYNC_DATABASE_SYNC_ERROR_FOLDERNAME', $folder->getFolderName(), $safeFolderName);?>
            </div>
        </div>
    <?php ELSE: ?>
        <div class="card mb-3">
            <h2 class="card-header"><?php echo $folder->getFolderName()?></h2>
        </div>
            <div id="uploader"
                 data-max-file-size="<?php echo file_upload_max_size() ?>"
                 data-max-image-size="<?php echo $config->getImage()->getResizeImageSize() ?>"
                 data-do-resize="<?php echo $config->getImage()->doResizeOnUpload()?'true':'false'?>"
                 data-upload-url="<?php echo  Route::_("index.php?option=com_eventgallery&view=upload&task=upload.upload&folder=".htmlspecialchars($folder->getFolderName(), ENT_QUOTES, 'UTF-8')."&format=raw&",false); ?>"
                 data-google-picker-url-manage-accounts="<?php echo Route::_('index.php?option=com_eventgallery&view=googlephotosaccounts')?>"
                 data-google-picker-url-get-accounts="<?php echo Route::_('index.php?option=com_eventgallery&task=googlephotosaccount.getaccounts', false); ?>"
                 data-google-picker-url-new-session="<?php echo Route::_('index.php?option=com_eventgallery&task=googlephotosaccount.getpickersession&newsession=true', false); ?>"
                 data-google-picker-url-get-session="<?php echo Route::_('index.php?option=com_eventgallery&task=googlephotosaccount.getpickersession', false); ?>"
                 data-google-picker-url-get-images="<?php echo Route::_('index.php?option=com_eventgallery&task=googlephotosaccount.fetchimages', false)?>"
                 data-google-picker-url-get-image="<?php echo Route::_('index.php?option=com_eventgallery&task=googlephotosaccount.fetchimage', false)?>"
                 data-google-picker-url-get-video="<?php echo Route::_('index.php?option=com_eventgallery&task=googlephotosaccount.fetchimage', false)?>"
                 data-i18n="<?php echo htmlspecialchars(json_encode(($i18n)), ENT_QUOTES, 'UTF-8') ?>"
            ></div>

    <?PHP ENDIF ?>



<form action="<?php echo  Route::_('index.php'); ?>" method="post" name="adminForm" id="adminForm">

    <input type="hidden" name="option" value="com_eventgallery" />
    <input type="hidden" name="task" value="" />
    <?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>

</form>
