<?php
namespace Svenbluege\Component\Eventgallery\Api\Controller;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\ApiController;
use Joomla\CMS\Router\Route;
use Joomla\Database\DatabaseInterface;
use Joomla\Database\ParameterType;
use Rector\NetteKdyby\Tests\Rector\MethodCall\ReplaceMagicPropertyEventWithEventClassRector\Fixture\FileManager;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FileFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderFactory;

class ImageHitCounterController extends ApiController
{
    protected $contentType = 'ImageHitcounter';
    protected $default_view = 'ImageHitCounter';

    public function count() {

        $rawData = $this->input->json->getRaw();
        $data = json_decode($rawData, true);
        if (null == $data) return;

        $id = (int)$data['id'];

        $fileFactory = FileFactory::getInstance();
        $file = $fileFactory->getFileById($id);
        if ($file != null) {
            $file->countHit();
        }
    }
}