<?php
/**
 *
 * DO NOT EDIT THIS FILE! CREATE AN OVERRIDE!
 * This file gets overwritten with every update.
 *
 * Place your custom settings in a file config_override.php in this folder to make sure those settings do not get lost with an update.
 *
 * To override settings from this file, you only need to define the constants like:
 * define('COM_EVENTGALLERY_IMAGE_ORIGINAL_MAX_WIDTH', 1600);
 *
 * The override-file is called first, so there is no need to check for existing constant definitions before,
 *
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */



defined('_JEXEC') or die('Restricted access');

define('COM_EVENTGALLERY_ALLOWED_FILE_EXTENSIONS', ['jpg', 'gif', 'png', 'jpeg', 'webp', 'mp4']);
define('COM_EVENTGALLERY_ALLOWED_MIME_TYPES', ['image/jpeg','image/gif','image/png','image/webp', 'video/mp4']);

if (file_exists(JPATH_ROOT.'/components/com_eventgallery/config_override.php')) {
	require_once JPATH_ROOT.'/components/com_eventgallery/config_override.php';
}

// defines the path to the image source folder
if (!defined ('COM_EVENTGALLERY_IMAGE_FOLDER_PATH')) {
	define('COM_EVENTGALLERY_IMAGE_FOLDER_PATH', JPATH_ROOT . DIRECTORY_SEPARATOR . 'images' . DIRECTORY_SEPARATOR . 'eventgallery' . DIRECTORY_SEPARATOR);
}

// define the path to the images on the webserver
if (!defined ('COM_EVENTGALLERY_IMAGE_FOLDER_WEB_PATH')) {
    define('COM_EVENTGALLERY_IMAGE_FOLDER_WEB_PATH',  'images/eventgallery');
}

// defines the path to the image cache folder
if (!defined('COM_EVENTGALLERY_IMAGE_CACHE_PATH')) {
    define('COM_EVENTGALLERY_IMAGE_CACHE_PATH', JPATH_ROOT . DIRECTORY_SEPARATOR . 'images' . DIRECTORY_SEPARATOR . 'eventgallery_generated' . DIRECTORY_SEPARATOR);
}

// defines the webpath to the cache directory
if (!defined('COM_EVENTGALLERY_IMAGE_CACHE_WEB_PATH')) {
    define('COM_EVENTGALLERY_IMAGE_CACHE_WEB_PATH', 'images/eventgallery_generated');
}

// Defines the image size which is used to copy images from Google Photos
if (!defined('COM_EVENTGALLERY_GOOGLE_PHOTOS_IMAGE_SIZE_OF_COPY')) {
    define('COM_EVENTGALLERY_GOOGLE_PHOTOS_IMAGE_SIZE_OF_COPY', 2400);
}

// defines the path to the google photos xml cache folder
if (!defined('COM_EVENTGALLERY_GOOGLE_PHOTOS_CACHE_PATH')) {
    define('COM_EVENTGALLERY_GOOGLE_PHOTOS_CACHE_PATH', preg_replace('/administrator[\/\\\\]+/', '', JPATH_CACHE . DIRECTORY_SEPARATOR . 'com_eventgallery_googlephotos' . DIRECTORY_SEPARATOR));
}

// defines the path to the google photos xml cache folder
if (!defined('COM_EVENTGALLERY_GOOGLE_PHOTOS_SHAREDPAGE_CACHE_PATH')) {
    define('COM_EVENTGALLERY_GOOGLE_PHOTOS_SHAREDPAGE_CACHE_PATH', preg_replace('/administrator[\/\\\\]+/', '', JPATH_CACHE . DIRECTORY_SEPARATOR . 'com_eventgallery_googlephotos_sharedpage' . DIRECTORY_SEPARATOR));
}

// defines the path to the flickr cache folder
if (!defined('COM_EVENTGALLERY_FLICKR_CACHE_PATH')) {
	define('COM_EVENTGALLERY_FLICKR_CACHE_PATH', preg_replace('/administrator[\/\\\\]+/', '', JPATH_CACHE . DIRECTORY_SEPARATOR . 'com_eventgallery_flickr' . DIRECTORY_SEPARATOR));
}

/**
 * If you upload images smaller than 2048px, this value must allow original images.
 *
 * 0 > 2049
 * k == 2048
 * h == 1600
 * b == 1024
 */
if(!defined('COM_EVENTGALLERY_FLICKR_MAX_IMAGE_SIZE')) {
	define('COM_EVENTGALLERY_FLICKR_MAX_IMAGE_SIZE', 2049);
}

// defines the path to the xml cache folder
if (!defined('COM_EVENTGALLERY_GENERAL_CACHE_PATH')) {
	define('COM_EVENTGALLERY_GENERAL_CACHE_PATH', preg_replace('/administrator[\/\\\\]+/', '', JPATH_CACHE . DIRECTORY_SEPARATOR . 'com_eventgallery' . DIRECTORY_SEPARATOR));
}

// maximum available image size This is used mostly for the images in the lightbox.
if (!defined('COM_EVENTGALLERY_IMAGE_ORIGINAL_MAX_WIDTH')) {
	define('COM_EVENTGALLERY_IMAGE_ORIGINAL_MAX_WIDTH', 1600);
}

// defines the thumbnail sizes which are used for Amazon S3 and local images. Remember that you might have to
// regenerate thumbnails.
if (!defined('COM_EVENTGALLERY_IMAGE_THUMBNAIL_SIZES')) {
    define('COM_EVENTGALLERY_IMAGE_THUMBNAIL_SIZES', [48, 104, 160, 288, 320, 400, 512, 640, 720, 800, 1024, 1280, 1440]);
}


/**
 * Defines how long to cache Google results for images. Since the image urls are only valid for 60 minutes and sometimes we
 * get urls which are not new, we need to keep this value as short as possible. But also as long as possible to avoid too many requests
 * to the Google Servers.
 */
if (!defined('COM_EVENTGALLERY_GOOGLE_PHOTOS_IMAGE_CACHE_LIFETIME')) {
    define('COM_EVENTGALLERY_GOOGLE_PHOTOS_IMAGE_CACHE_LIFETIME', 600);
}

if (!defined('COM_EVENTGALLERY_GOOGLE_PHOTOS_SHARED_PAGE_IMAGE_CACHE_LIFETIME')) {
    define('COM_EVENTGALLERY_GOOGLE_PHOTOS_SHARED_PAGE_IMAGE_CACHE_LIFETIME', 86400);
}

/**
 * Defines how long we cache a list of albums. This value is used for the album selector in the back end.
 */
if (!defined('COM_EVENTGALLERY_GOOGLE_PHOTOS_ALBUMS_CACHE_LIFETIME')) {
    define('COM_EVENTGALLERY_GOOGLE_PHOTOS_ALBUMS_CACHE_LIFETIME', 300);
}

// defines the size of the cart thumbnails.
if (!defined('COM_EVENTGALLERY_IMAGE_THUMBNAIL_IN_CART_WIDTH')) {
    define('COM_EVENTGALLERY_IMAGE_THUMBNAIL_IN_CART_WIDTH', 160);
}

// defines the size of the minicart thumbnails.
if (!defined('COM_EVENTGALLERY_IMAGE_THUMBNAIL_IN_MINICART_WIDTH')) {
    define('COM_EVENTGALLERY_IMAGE_THUMBNAIL_IN_MINICART_WIDTH', 48);
}

// folder name for original images
if (!defined('COM_EVENTGALLERY_IMAGE_ORIGINAL_SUBFOLDER')) {
    define('COM_EVENTGALLERY_IMAGE_ORIGINAL_SUBFOLDER', 'originals');
}

// the content of the .htaccess file
if (!defined('COM_EVENTGALLERY_IMAGE_PROTECTION_HTACCESS')) {
    define('COM_EVENTGALLERY_IMAGE_PROTECTION_HTACCESS', <<<CONFIG
<FilesMatch "(?i)\.(jpg|gif|png|jpeg|webp)$">
    Order Allow,Deny
    Deny from all
</FilesMatch>

<FilesMatch "(?i)\.(mp4)$">
    Order Allow,Deny
    Allow from all
</FilesMatch>
CONFIG);
}

// the content of the web.config file
if (!defined('COM_EVENTGALLERY_IMAGE_PROTECTION_WEB_CONFIG')) {
    define('COM_EVENTGALLERY_IMAGE_PROTECTION_WEB_CONFIG', <<<CONFIG
<?xml version="1.0" encoding="UTF-8"?>
<configuration>
    <system.webServer>
        <rewrite>
            <rules>
                <rule name="Block Image Files" stopProcessing="true">
                    <match url=".*\.(jpg|gif|png|jpeg|webp)$" ignoreCase="true" />
                    <action type="CustomResponse" statusCode="403" statusReason="Forbidden" statusDescription="Access to image files is denied." />
                </rule>
                <rule name="Allow Video Files" stopProcessing="true">
                    <match url=".*\.(mp4)$" ignoreCase="true" />
                    <action type="None" />
                </rule>
            </rules>
        </rewrite>
    </system.webServer>
</configuration>
CONFIG);
}

// the content of the index.html file
if (!defined('COM_EVENTGALLERY_IMAGE_PROTECTION_INDEX_HTML')) {
    define('COM_EVENTGALLERY_IMAGE_PROTECTION_INDEX_HTML', "<html>\n<body bgcolor=\"#FFFFFF\">\n</body>\n</html>");
}

// set the name of the image which is used for a redirect in case an image is not visible for the current user
if (!defined('COM_EVENTGALLERY_IMAGE_NO_ACCESS')) {
    define('COM_EVENTGALLERY_IMAGE_NO_ACCESS', 'media/com_eventgallery/frontend/images/locked.png');
}

if (!defined('COM_EVENTGALLERY_VIDEO_PLACEHOLDER_IMAGE')) {
    define('COM_EVENTGALLERY_VIDEO_PLACEHOLDER_IMAGE', 'media/com_eventgallery/frontend/images/video_placeholder.jpg');
}


// defines the path to the google photos loading spinner. The name needs to be exactly gp.svg, but you can change the path.
if (!defined('COM_EVENTGALLERY_GOOGLEPHOTOS_LOADING_IMAGE_PATH')) {
    define('COM_EVENTGALLERY_GOOGLEPHOTOS_LOADING_IMAGE_PATH', 'media/com_eventgallery/frontend/images');
}

/**
 * Here you can find the codes for the fields. They are usually referenced like 2:05,
 * For this configuration, replace the colon with a hashsign. Make is a three-digit number.
 *
 * Example: The title if 2:05 in the reference, here you need to specify 2#005
 *
 * https://www.iptc.org/std/photometadata/specification/IPTC-PhotoMetadata#metadata-properties
 */
if (!defined('COM_EVENTGALLERY_IMAGE_METADATA_IPTC_FIELD_TITLE')) {
    define('COM_EVENTGALLERY_IMAGE_METADATA_IPTC_FIELD_TITLE', '2#005');
}

if (!defined('COM_EVENTGALLERY_IMAGE_METADATA_IPTC_FIELD_CAPTION')) {
    define('COM_EVENTGALLERY_IMAGE_METADATA_IPTC_FIELD_CAPTION', '2#120');
}
