<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Controller;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Svenbluege\Component\Eventgallery\Site\Library\Manager\CartManager;

defined('_JEXEC') or die;

class CartController extends \Joomla\CMS\MVC\Controller\BaseController
{
    public function display($cachable = false, $urlparams = array())
    {
        parent::display(false, $urlparams);
    }

    public function cloneLineItem()
    {
        $lineitemid = $this->input->getString('lineitemid', NULL);
        /* @var CartManager $cartMgr */
        $cartMgr = CartManager::getInstance();
        $cart = $cartMgr->getCart();
        $lineitem = $cart->getLineItem($lineitemid);
        if ($lineitem != NULL) {
            $cart->cloneLineItem($lineitemid);
        }

        $cartMgr->calculateCart();

        $this->setRedirect( Route::_("index.php?option=com_eventgallery&view=cart"));
    }

    /**
     * updates the cart
     */
    public function updateCart()
    {

        // Check for request forgeries.
        Session::checkToken() or jexit(\Joomla\CMS\Language\Text::_('JINVALID_TOKEN'));
        /* @var CartManager $cartMgr */
        $cartMgr = CartManager::getInstance();
        $cartMgr->updateLineItems();
        $cartMgr->calculateCart();

        $continue = $this->input->getString('continue', NULL);

        if ($continue == NULL) {
            $this->setRedirect( Route::_("index.php?option=com_eventgallery&view=cart"));
        } else {
            $this->setRedirect( Route::_("index.php?option=com_eventgallery&view=checkout"));
        }
    }


}
